package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 支付宝BC聊天，会话附加成员信息模型
 *
 * @author auto create
 * @since 1.0, 2021-04-16 14:57:22
 */
public class BcSessionMemberInfo extends AlipayObject {

	private static final long serialVersionUID = 6886924835397727337L;

	/**
	 * BC会话附加成员的可外网访问头像地址。如云客服服务人员的头像
	 */
	@ApiField("outer_user_avatar")
	private String outerUserAvatar;

	/**
	 * BC会话附加成员的唯一标识。如云客服客服人员的id
	 */
	@ApiField("outer_user_id")
	private String outerUserId;

	/**
	 * BC会话附加成员的昵称。如云客服客服人员的昵称
	 */
	@ApiField("outer_user_nick")
	private String outerUserNick;

	public String getOuterUserAvatar() {
		return this.outerUserAvatar;
	}
	public void setOuterUserAvatar(String outerUserAvatar) {
		this.outerUserAvatar = outerUserAvatar;
	}

	public String getOuterUserId() {
		return this.outerUserId;
	}
	public void setOuterUserId(String outerUserId) {
		this.outerUserId = outerUserId;
	}

	public String getOuterUserNick() {
		return this.outerUserNick;
	}
	public void setOuterUserNick(String outerUserNick) {
		this.outerUserNick = outerUserNick;
	}

}
