package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 卡皮肤模型返回结果
 *
 * @author auto create
 * @since 1.0, 2021-12-14 20:28:49
 */
public class CardStyleDTO extends AlipayObject {

	private static final long serialVersionUID = 3768878335491588996L;

	/**
	 * 支付宝uid
	 */
	@ApiField("alipay_user_id")
	private String alipayUserId;

	/**
	 * 业务时间｜接口传
	 */
	@ApiField("biz_date")
	private String bizDate;

	/**
	 * 环境标识
	 */
	@ApiField("env")
	private String env;

	/**
	 * 扩展信息
	 */
	@ApiField("ext_info")
	private CardStyleExtInfo extInfo;

	/**
	 * 创建时间
	 */
	@ApiField("gmt_create")
	private String gmtCreate;

	/**
	 * 修改时间
	 */
	@ApiField("gmt_modified")
	private Date gmtModified;

	/**
	 * 网商ipid
	 */
	@ApiField("ip_id")
	private String ipId;

	/**
	 * 网商roleid
	 */
	@ApiField("ip_role_id")
	private String ipRoleId;

	/**
	 * 链接描述｜取模版
	 */
	@ApiField("link_desc")
	private String linkDesc;

	/**
	 * 链接资源｜接口传
	 */
	@ApiField("link_resource")
	private String linkResource;

	/**
	 * 链接资源类型｜取模版
	 */
	@ApiField("link_resource_type")
	private String linkResourceType;

	/**
	 * 链接标题｜取模版
	 */
	@ApiField("link_title")
	private String linkTitle;

	/**
	 * 是否需要跳转｜接口传
	 */
	@ApiField("need_link")
	private Boolean needLink;

	/**
	 * 模版平台属性｜取模版
	 */
	@ApiField("platplat_prop")
	private String platplatProp;

	/**
	 * 状态｜VALID/INVALID
	 */
	@ApiField("status")
	private String status;

	/**
	 * 皮肤描述｜取模版描述
	 */
	@ApiField("style_desc")
	private String styleDesc;

	/**
	 * 皮肤ID
	 */
	@ApiField("style_id")
	private String styleId;

	/**
	 * 皮肤名称｜取模版名称
	 */
	@ApiField("style_name")
	private String styleName;

	/**
	 * 排序｜取模版
	 */
	@ApiField("style_order")
	private String styleOrder;

	/**
	 * 原始单据｜水母订单号
	 */
	@ApiField("style_origin_id")
	private String styleOriginId;

	/**
	 * 皮肤资源｜接口传
	 */
	@ApiField("style_resource")
	private String styleResource;

	/**
	 * 卡皮肤图片资源类型｜取模版
	 */
	@ApiField("style_resource_type")
	private String styleResourceType;

	/**
	 * 模版ID
	 */
	@ApiField("template_id")
	private String templateId;

	public String getAlipayUserId() {
		return this.alipayUserId;
	}
	public void setAlipayUserId(String alipayUserId) {
		this.alipayUserId = alipayUserId;
	}

	public String getBizDate() {
		return this.bizDate;
	}
	public void setBizDate(String bizDate) {
		this.bizDate = bizDate;
	}

	public String getEnv() {
		return this.env;
	}
	public void setEnv(String env) {
		this.env = env;
	}

	public CardStyleExtInfo getExtInfo() {
		return this.extInfo;
	}
	public void setExtInfo(CardStyleExtInfo extInfo) {
		this.extInfo = extInfo;
	}

	public String getGmtCreate() {
		return this.gmtCreate;
	}
	public void setGmtCreate(String gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return this.gmtModified;
	}
	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getIpId() {
		return this.ipId;
	}
	public void setIpId(String ipId) {
		this.ipId = ipId;
	}

	public String getIpRoleId() {
		return this.ipRoleId;
	}
	public void setIpRoleId(String ipRoleId) {
		this.ipRoleId = ipRoleId;
	}

	public String getLinkDesc() {
		return this.linkDesc;
	}
	public void setLinkDesc(String linkDesc) {
		this.linkDesc = linkDesc;
	}

	public String getLinkResource() {
		return this.linkResource;
	}
	public void setLinkResource(String linkResource) {
		this.linkResource = linkResource;
	}

	public String getLinkResourceType() {
		return this.linkResourceType;
	}
	public void setLinkResourceType(String linkResourceType) {
		this.linkResourceType = linkResourceType;
	}

	public String getLinkTitle() {
		return this.linkTitle;
	}
	public void setLinkTitle(String linkTitle) {
		this.linkTitle = linkTitle;
	}

	public Boolean getNeedLink() {
		return this.needLink;
	}
	public void setNeedLink(Boolean needLink) {
		this.needLink = needLink;
	}

	public String getPlatplatProp() {
		return this.platplatProp;
	}
	public void setPlatplatProp(String platplatProp) {
		this.platplatProp = platplatProp;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

	public String getStyleDesc() {
		return this.styleDesc;
	}
	public void setStyleDesc(String styleDesc) {
		this.styleDesc = styleDesc;
	}

	public String getStyleId() {
		return this.styleId;
	}
	public void setStyleId(String styleId) {
		this.styleId = styleId;
	}

	public String getStyleName() {
		return this.styleName;
	}
	public void setStyleName(String styleName) {
		this.styleName = styleName;
	}

	public String getStyleOrder() {
		return this.styleOrder;
	}
	public void setStyleOrder(String styleOrder) {
		this.styleOrder = styleOrder;
	}

	public String getStyleOriginId() {
		return this.styleOriginId;
	}
	public void setStyleOriginId(String styleOriginId) {
		this.styleOriginId = styleOriginId;
	}

	public String getStyleResource() {
		return this.styleResource;
	}
	public void setStyleResource(String styleResource) {
		this.styleResource = styleResource;
	}

	public String getStyleResourceType() {
		return this.styleResourceType;
	}
	public void setStyleResourceType(String styleResourceType) {
		this.styleResourceType = styleResourceType;
	}

	public String getTemplateId() {
		return this.templateId;
	}
	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}

}
