package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 分渠道成交统计
 *
 * @author auto create
 * @since 1.0, 2020-09-23 14:57:48
 */
public class ChannelDealStatistic extends AlipayObject {

	private static final long serialVersionUID = 4596988576641663746L;

	/**
	 * 本字段用于成交的渠道，用于区分支付宝渠道、其他渠道
	 */
	@ApiField("channel")
	private String channel;

	/**
	 * 成交金额，描述为元角分
	 */
	@ApiField("transaction_amount")
	private String transactionAmount;

	/**
	 * 成交笔数
	 */
	@ApiField("transaction_cnt")
	private Long transactionCnt;

	/**
	 * 成交用户数
	 */
	@ApiField("user_cnt")
	private Long userCnt;

	public String getChannel() {
		return this.channel;
	}
	public void setChannel(String channel) {
		this.channel = channel;
	}

	public String getTransactionAmount() {
		return this.transactionAmount;
	}
	public void setTransactionAmount(String transactionAmount) {
		this.transactionAmount = transactionAmount;
	}

	public Long getTransactionCnt() {
		return this.transactionCnt;
	}
	public void setTransactionCnt(Long transactionCnt) {
		this.transactionCnt = transactionCnt;
	}

	public Long getUserCnt() {
		return this.userCnt;
	}
	public void setUserCnt(Long userCnt) {
		this.userCnt = userCnt;
	}

}
