package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 投放基础信息
 *
 * @author auto create
 * @since 1.0, 2021-12-15 21:43:24
 */
public class DeliveryBaseInfo extends AlipayObject {

	private static final long serialVersionUID = 1237551256728468958L;

	/**
	 * 投放开始时间，开始时间达到后，此次投放正式生效。 格式为：yyyy-MM-dd HH:mm:ss。
	 */
	@ApiField("begin_time")
	private Date beginTime;

	/**
	 * 投放素材信息。主要包含商品图片等信息
	 */
	@ApiField("delivery_matrial")
	private DeliveryMatrial deliveryMatrial;

	/**
	 * 投放名称。

目前投放名称不会对用户进行表达。只用于商户管理时使用。
	 */
	@ApiField("delivery_name")
	private String deliveryName;

	/**
	 * 投放结束时间。 格式为：yyyy-MM-dd HH:mm:ss
	 */
	@ApiField("end_time")
	private String endTime;

	public Date getBeginTime() {
		return this.beginTime;
	}
	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}

	public DeliveryMatrial getDeliveryMatrial() {
		return this.deliveryMatrial;
	}
	public void setDeliveryMatrial(DeliveryMatrial deliveryMatrial) {
		this.deliveryMatrial = deliveryMatrial;
	}

	public String getDeliveryName() {
		return this.deliveryName;
	}
	public void setDeliveryName(String deliveryName) {
		this.deliveryName = deliveryName;
	}

	public String getEndTime() {
		return this.endTime;
	}
	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

}
