package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 投放内容信息。
 *
 * @author auto create
 * @since 1.0, 2021-12-15 22:04:17
 */
public class DeliveryContentInfo extends AlipayObject {

	private static final long serialVersionUID = 1278139196587455625L;

	/**
	 * 活动内容。

限制：当content_type选择ACTIVITY时，该字段必填。
	 */
	@ApiField("activity_content")
	private ActivityContentInfo activityContent;

	/**
	 * 投放内容类型。

枚举值：
ACTIVITY：商家券活动 或者 支付券活动。

说明：
ACTIVITY类型的内容包含，通过openapi接口创建的支付券与商家券活动 或者 通过B、P站创建的支付券活动。
	 */
	@ApiField("content_type")
	private String contentType;

	public ActivityContentInfo getActivityContent() {
		return this.activityContent;
	}
	public void setActivityContent(ActivityContentInfo activityContent) {
		this.activityContent = activityContent;
	}

	public String getContentType() {
		return this.contentType;
	}
	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

}
