package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 可曝光的商户信息列表。
 *
 * @author auto create
 * @since 1.0, 2021-12-16 14:15:54
 */
public class DeliveryMerchantInfo extends AlipayObject {

	private static final long serialVersionUID = 8463384735642624573L;

	/**
	 * 商户id
	 */
	@ApiField("merchant_id")
	private String merchantId;

	/**
	 * 商户id类型。 
枚举值：
 SMID： 间连商户 
PID： 直连商户
	 */
	@ApiField("merchant_id_type")
	private String merchantIdType;

	/**
	 * 曝光商户号选取规则，

枚举值：
ACTIVITY_AVAILABLE_MERCHANT：活动可用商户号
MANUAL_INPUT_MERCHANT：手动输入曝光商户号

说明：
支付券只能选择ACTIVITY_AVAILABLE_MERCHANT。
默认将支付券的可用商户号作为曝光商户号。

商家券只能选择MANUAL_INPUT_MERCHANT。传入的商户号必须与商家券的归属商户属于同一品牌，或者进行过跨品牌授权。
	 */
	@ApiField("merchant_option")
	private String merchantOption;

	public String getMerchantId() {
		return this.merchantId;
	}
	public void setMerchantId(String merchantId) {
		this.merchantId = merchantId;
	}

	public String getMerchantIdType() {
		return this.merchantIdType;
	}
	public void setMerchantIdType(String merchantIdType) {
		this.merchantIdType = merchantIdType;
	}

	public String getMerchantOption() {
		return this.merchantOption;
	}
	public void setMerchantOption(String merchantOption) {
		this.merchantOption = merchantOption;
	}

}
