package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 投放玩法配置。例如：支付后满门槛送券。
投放玩法配置与展位编码booth_code相关。不同的booth_code能够配置的玩法不同。
 *
 * @author auto create
 * @since 1.0, 2021-12-15 22:20:14
 */
public class DeliveryPlayConfig extends AlipayObject {

	private static final long serialVersionUID = 1748297967483146644L;

	/**
	 * 满送玩法配置。 限制：booth_code选择PAY_REUSLT时，才可以进行配置。 含义：用户支付满足一定门槛后，才能够在支付成功页面领取商户投放的活动。 说明：可投放的活动类型在满减玩法配置中进行说明。
	 */
	@ApiField("full_send_config")
	private FullSendConfig fullSendConfig;

	/**
	 * 单一内容配置。 

限制：所有类型的booth_code均可进行单一内容配置。

说明：单一内容配置不涉及复杂玩法。将指定内容投放到指定展位进行曝光。
	 */
	@ApiField("single_send_config")
	private SingleSendConfig singleSendConfig;

	public FullSendConfig getFullSendConfig() {
		return this.fullSendConfig;
	}
	public void setFullSendConfig(FullSendConfig fullSendConfig) {
		this.fullSendConfig = fullSendConfig;
	}

	public SingleSendConfig getSingleSendConfig() {
		return this.singleSendConfig;
	}
	public void setSingleSendConfig(SingleSendConfig singleSendConfig) {
		this.singleSendConfig = singleSendConfig;
	}

}
