package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 投放定向规则。

说明：不同的booth_code涉及的定向规则有所不同。
 *
 * @author auto create
 * @since 1.0, 2021-12-15 22:21:52
 */
public class DeliveryTargetRule extends AlipayObject {

	private static final long serialVersionUID = 7696257791577154457L;

	/**
	 * 可曝光的商户信息列表。

限制：booth_code选择PAY_RESULT，该字段必须填写。
	 */
	@ApiListField("delivery_merchant_infos")
	@ApiField("delivery_merchant_info")
	private List<DeliveryMerchantInfo> deliveryMerchantInfos;

	public List<DeliveryMerchantInfo> getDeliveryMerchantInfos() {
		return this.deliveryMerchantInfos;
	}
	public void setDeliveryMerchantInfos(List<DeliveryMerchantInfo> deliveryMerchantInfos) {
		this.deliveryMerchantInfos = deliveryMerchantInfos;
	}

}
