package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 展台节点
 *
 * @author auto create
 * @since 1.0, 2020-01-02 16:01:29
 */
public class DisplayAppNodeT extends AlipayObject {

	private static final long serialVersionUID = 8462693649376912555L;

	/**
	 * 服务信息
	 */
	@ApiField("app_info")
	private AppInfo appInfo;

	/**
	 * 展台背景图
	 */
	@ApiField("background_url")
	private String backgroundUrl;

	/**
	 * 展台文案
	 */
	@ApiField("caption")
	private String caption;

	/**
	 * 展台编码
	 */
	@ApiField("code")
	private String code;

	/**
	 * 角标文案
	 */
	@ApiField("corner_mark_caption")
	private String cornerMarkCaption;

	/**
	 * 角标id
	 */
	@ApiField("corner_mark_id")
	private Long cornerMarkId;

	/**
	 * 角标类型
	 */
	@ApiField("corner_mark_type")
	private String cornerMarkType;

	/**
	 * 展台图标url
	 */
	@ApiField("icon_url")
	private String iconUrl;

	/**
	 * 展台ID
	 */
	@ApiField("id")
	private String id;

	/**
	 * 展台跳转url
	 */
	@ApiField("jump_url")
	private String jumpUrl;

	/**
	 * 展台名称
	 */
	@ApiField("name")
	private String name;

	/**
	 * 父节点的代码
	 */
	@ApiField("parent_code")
	private String parentCode;

	/**
	 * 父节点的id
	 */
	@ApiField("parent_id")
	private Long parentId;

	/**
	 * 展台在兄弟节点中的排序
	 */
	@ApiField("rank")
	private Long rank;

	/**
	 * 展台状态。NORMAL：正常，MAINTAIN：维护，UNVALID：无效
	 */
	@ApiField("status")
	private String status;

	/**
	 * 展台标题
	 */
	@ApiField("title")
	private String title;

	/**
	 * 展台类型。DISPLAYAPP：展台，CATEGORY：分类
	 */
	@ApiField("type")
	private String type;

	public AppInfo getAppInfo() {
		return this.appInfo;
	}
	public void setAppInfo(AppInfo appInfo) {
		this.appInfo = appInfo;
	}

	public String getBackgroundUrl() {
		return this.backgroundUrl;
	}
	public void setBackgroundUrl(String backgroundUrl) {
		this.backgroundUrl = backgroundUrl;
	}

	public String getCaption() {
		return this.caption;
	}
	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getCode() {
		return this.code;
	}
	public void setCode(String code) {
		this.code = code;
	}

	public String getCornerMarkCaption() {
		return this.cornerMarkCaption;
	}
	public void setCornerMarkCaption(String cornerMarkCaption) {
		this.cornerMarkCaption = cornerMarkCaption;
	}

	public Long getCornerMarkId() {
		return this.cornerMarkId;
	}
	public void setCornerMarkId(Long cornerMarkId) {
		this.cornerMarkId = cornerMarkId;
	}

	public String getCornerMarkType() {
		return this.cornerMarkType;
	}
	public void setCornerMarkType(String cornerMarkType) {
		this.cornerMarkType = cornerMarkType;
	}

	public String getIconUrl() {
		return this.iconUrl;
	}
	public void setIconUrl(String iconUrl) {
		this.iconUrl = iconUrl;
	}

	public String getId() {
		return this.id;
	}
	public void setId(String id) {
		this.id = id;
	}

	public String getJumpUrl() {
		return this.jumpUrl;
	}
	public void setJumpUrl(String jumpUrl) {
		this.jumpUrl = jumpUrl;
	}

	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public String getParentCode() {
		return this.parentCode;
	}
	public void setParentCode(String parentCode) {
		this.parentCode = parentCode;
	}

	public Long getParentId() {
		return this.parentId;
	}
	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public Long getRank() {
		return this.rank;
	}
	public void setRank(Long rank) {
		this.rank = rank;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

	public String getTitle() {
		return this.title;
	}
	public void setTitle(String title) {
		this.title = title;
	}

	public String getType() {
		return this.type;
	}
	public void setType(String type) {
		this.type = type;
	}

}
