package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 用例节点
 *
 * @author auto create
 * @since 1.0, 2020-02-26 12:10:26
 */
public class EcoqualityCaseNode extends AlipayObject {

	private static final long serialVersionUID = 1124349925889487784L;

	/**
	 * 直属用例列表
	 */
	@ApiListField("children_case")
	@ApiField("number")
	private List<Long> childrenCase;

	/**
	 * 子节点id列表
	 */
	@ApiListField("children_node")
	@ApiField("number")
	private List<Long> childrenNode;

	/**
	 * 描述
	 */
	@ApiField("desc")
	private String desc;

	/**
	 * id
	 */
	@ApiField("id")
	private Long id;

	/**
	 * 节点名称
	 */
	@ApiField("name")
	private String name;

	/**
	 * 节点类型: dir/case
	 */
	@ApiField("type")
	private String type;

	public List<Long> getChildrenCase() {
		return this.childrenCase;
	}
	public void setChildrenCase(List<Long> childrenCase) {
		this.childrenCase = childrenCase;
	}

	public List<Long> getChildrenNode() {
		return this.childrenNode;
	}
	public void setChildrenNode(List<Long> childrenNode) {
		this.childrenNode = childrenNode;
	}

	public String getDesc() {
		return this.desc;
	}
	public void setDesc(String desc) {
		this.desc = desc;
	}

	public Long getId() {
		return this.id;
	}
	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return this.type;
	}
	public void setType(String type) {
		this.type = type;
	}

}
