package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 机场数据模型
 *
 * @author auto create
 * @since 1.0, 2021-10-27 22:16:20
 */
public class FlightAirport extends AlipayObject {

	private static final long serialVersionUID = 2259644435422769657L;

	/**
	 * 实际时间，机场当地时间。格式为：YYYY-MM-DD HH:mm:ss
	 */
	@ApiField("actual_time")
	private String actualTime;

	/**
	 * 机场三字码。取值为IATA定义的机场三字码
	 */
	@ApiField("airport_iata_code")
	private String airportIataCode;

	/**
	 * 机场四字码
	 */
	@ApiField("airport_iato_code")
	private String airportIatoCode;

	/**
	 * 机场名称
	 */
	@ApiField("airport_name")
	private String airportName;

	/**
	 * 机场名称英文
	 */
	@ApiField("airport_name_en")
	private String airportNameEn;

	/**
	 * 行李盘号
	 */
	@ApiField("baggage_tuentable")
	private String baggageTuentable;

	/**
	 * 登机口
	 */
	@ApiField("board_gate")
	private String boardGate;

	/**
	 * 登机口辅助信息
	 */
	@ApiField("board_gate_desc")
	private String boardGateDesc;

	/**
	 * 登机序号。值机后产生
	 */
	@ApiField("board_num")
	private String boardNum;

	/**
	 * 值机台
	 */
	@ApiField("check_in_desk")
	private String checkInDesk;

	/**
	 * 机场所属城市名称
	 */
	@ApiField("city_name")
	private String cityName;

	/**
	 * 机场所属城市英文
	 */
	@ApiField("city_name_en")
	private String cityNameEn;

	/**
	 * 计划时间，机场当地时间，格式为YYYY-MM-DD HH:mm:ss
	 */
	@ApiField("scheduled_time")
	private String scheduledTime;

	/**
	 * 安检口
	 */
	@ApiField("security_gate")
	private String securityGate;

	/**
	 * 安检辅助信息
	 */
	@ApiField("security_gate_desc")
	private String securityGateDesc;

	/**
	 * 机场航站楼名称
	 */
	@ApiField("terminal_name")
	private String terminalName;

	public String getActualTime() {
		return this.actualTime;
	}
	public void setActualTime(String actualTime) {
		this.actualTime = actualTime;
	}

	public String getAirportIataCode() {
		return this.airportIataCode;
	}
	public void setAirportIataCode(String airportIataCode) {
		this.airportIataCode = airportIataCode;
	}

	public String getAirportIatoCode() {
		return this.airportIatoCode;
	}
	public void setAirportIatoCode(String airportIatoCode) {
		this.airportIatoCode = airportIatoCode;
	}

	public String getAirportName() {
		return this.airportName;
	}
	public void setAirportName(String airportName) {
		this.airportName = airportName;
	}

	public String getAirportNameEn() {
		return this.airportNameEn;
	}
	public void setAirportNameEn(String airportNameEn) {
		this.airportNameEn = airportNameEn;
	}

	public String getBaggageTuentable() {
		return this.baggageTuentable;
	}
	public void setBaggageTuentable(String baggageTuentable) {
		this.baggageTuentable = baggageTuentable;
	}

	public String getBoardGate() {
		return this.boardGate;
	}
	public void setBoardGate(String boardGate) {
		this.boardGate = boardGate;
	}

	public String getBoardGateDesc() {
		return this.boardGateDesc;
	}
	public void setBoardGateDesc(String boardGateDesc) {
		this.boardGateDesc = boardGateDesc;
	}

	public String getBoardNum() {
		return this.boardNum;
	}
	public void setBoardNum(String boardNum) {
		this.boardNum = boardNum;
	}

	public String getCheckInDesk() {
		return this.checkInDesk;
	}
	public void setCheckInDesk(String checkInDesk) {
		this.checkInDesk = checkInDesk;
	}

	public String getCityName() {
		return this.cityName;
	}
	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	public String getCityNameEn() {
		return this.cityNameEn;
	}
	public void setCityNameEn(String cityNameEn) {
		this.cityNameEn = cityNameEn;
	}

	public String getScheduledTime() {
		return this.scheduledTime;
	}
	public void setScheduledTime(String scheduledTime) {
		this.scheduledTime = scheduledTime;
	}

	public String getSecurityGate() {
		return this.securityGate;
	}
	public void setSecurityGate(String securityGate) {
		this.securityGate = securityGate;
	}

	public String getSecurityGateDesc() {
		return this.securityGateDesc;
	}
	public void setSecurityGateDesc(String securityGateDesc) {
		this.securityGateDesc = securityGateDesc;
	}

	public String getTerminalName() {
		return this.terminalName;
	}
	public void setTerminalName(String terminalName) {
		this.terminalName = terminalName;
	}

}
