package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 航班动态实体
 *
 * @author auto create
 * @since 1.0, 2021-10-27 22:07:39
 */
public class FlightInfo extends AlipayObject {

	private static final long serialVersionUID = 6567428174298527468L;

	/**
	 * 机龄
	 */
	@ApiField("aircraft_age")
	private String aircraftAge;

	/**
	 * 飞机型号
	 */
	@ApiField("aircraft_type")
	private String aircraftType;

	/**
	 * 航空公司logo地址
	 */
	@ApiField("company_logo")
	private String companyLogo;

	/**
	 * 航空公司名称
	 */
	@ApiField("company_name")
	private String companyName;

	/**
	 * 仓位图
	 */
	@ApiField("flight_cabin")
	private String flightCabin;

	/**
	 * 飞行时长，单位分钟
	 */
	@ApiField("flight_duration")
	private Long flightDuration;

	/**
	 * 航班号
	 */
	@ApiField("flight_no")
	private String flightNo;

	/**
	 * 飞行距离
	 */
	@ApiField("flight_range")
	private String flightRange;

	/**
	 * 航班动态。取值请与开发确认，例如Scheduled表示计划中
	 */
	@ApiField("flight_status")
	private String flightStatus;

	/**
	 * 航班动态描述
	 */
	@ApiField("flight_status_desc")
	private String flightStatusDesc;

	/**
	 * 准点率
	 */
	@ApiField("punctuality_rate")
	private String punctualityRate;

	public String getAircraftAge() {
		return this.aircraftAge;
	}
	public void setAircraftAge(String aircraftAge) {
		this.aircraftAge = aircraftAge;
	}

	public String getAircraftType() {
		return this.aircraftType;
	}
	public void setAircraftType(String aircraftType) {
		this.aircraftType = aircraftType;
	}

	public String getCompanyLogo() {
		return this.companyLogo;
	}
	public void setCompanyLogo(String companyLogo) {
		this.companyLogo = companyLogo;
	}

	public String getCompanyName() {
		return this.companyName;
	}
	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public String getFlightCabin() {
		return this.flightCabin;
	}
	public void setFlightCabin(String flightCabin) {
		this.flightCabin = flightCabin;
	}

	public Long getFlightDuration() {
		return this.flightDuration;
	}
	public void setFlightDuration(Long flightDuration) {
		this.flightDuration = flightDuration;
	}

	public String getFlightNo() {
		return this.flightNo;
	}
	public void setFlightNo(String flightNo) {
		this.flightNo = flightNo;
	}

	public String getFlightRange() {
		return this.flightRange;
	}
	public void setFlightRange(String flightRange) {
		this.flightRange = flightRange;
	}

	public String getFlightStatus() {
		return this.flightStatus;
	}
	public void setFlightStatus(String flightStatus) {
		this.flightStatus = flightStatus;
	}

	public String getFlightStatusDesc() {
		return this.flightStatusDesc;
	}
	public void setFlightStatusDesc(String flightStatusDesc) {
		this.flightStatusDesc = flightStatusDesc;
	}

	public String getPunctualityRate() {
		return this.punctualityRate;
	}
	public void setPunctualityRate(String punctualityRate) {
		this.punctualityRate = punctualityRate;
	}

}
