package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 满送玩法配置。

限制：booth_code选择PAY_REUSLT时，才可以进行配置。
含义：用户支付满足一定门槛后，才能够在支付成功页面领取商户投放的活动。
说明：可投放的活动类型在满减玩法配置中进行说明。
 *
 * @author auto create
 * @since 1.0, 2021-12-15 22:18:28
 */
public class FullSendConfig extends AlipayObject {

	private static final long serialVersionUID = 5452262663583167599L;

	/**
	 * 投放内容信息。

说明：当满足floor_amount条件后，用户可领取的投放内容信息。
	 */
	@ApiField("delivery_content_info")
	private DeliveryContentInfo deliveryContentInfo;

	/**
	 * 消费金额金额。

说明：该字段指支付时的订单金额最少满足的金额门槛。
	 */
	@ApiField("floor_amount")
	private String floorAmount;

	public DeliveryContentInfo getDeliveryContentInfo() {
		return this.deliveryContentInfo;
	}
	public void setDeliveryContentInfo(DeliveryContentInfo deliveryContentInfo) {
		this.deliveryContentInfo = deliveryContentInfo;
	}

	public String getFloorAmount() {
		return this.floorAmount;
	}
	public void setFloorAmount(String floorAmount) {
		this.floorAmount = floorAmount;
	}

}
