package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 保险查询用户的精简模型定义
 *
 * @author auto create
 * @since 1.0, 2021-09-13 15:42:02
 */
public class InsQueryByPerson extends AlipayObject {

	private static final long serialVersionUID = 5388224684626191724L;

	/**
	 * 渠道账号对应的uid
	 */
	@ApiField("channel_user_id")
	private String channelUserId;

	/**
	 * 渠道账号来源: 1:支付宝账号; 2:淘宝账号; 如果证件类型字段没填则必填。 和channel_user_id 配对
	 */
	@ApiField("channel_user_source")
	private String channelUserSource;

	/**
	 * 搜索用户类型，取值 1：按照投保人搜索 2：按照被保人搜索
	 */
	@ApiField("type")
	private String type;

	public String getChannelUserId() {
		return this.channelUserId;
	}
	public void setChannelUserId(String channelUserId) {
		this.channelUserId = channelUserId;
	}

	public String getChannelUserSource() {
		return this.channelUserSource;
	}
	public void setChannelUserSource(String channelUserSource) {
		this.channelUserSource = channelUserSource;
	}

	public String getType() {
		return this.type;
	}
	public void setType(String type) {
		this.type = type;
	}

}
