package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 同步企业税务信息请求
 *
 * @author auto create
 * @since 1.0, 2020-05-25 22:55:43
 */
public class InvoiceCompanyUpdateDTO extends AlipayObject {

	private static final long serialVersionUID = 7343259797643452894L;

	/**
	 * 发票限额信息
	 */
	@ApiListField("amount_limit_dto_list")
	@ApiField("invoice_amount_limit_d_t_o")
	private List<InvoiceAmountLimitDTO> amountLimitDtoList;

	/**
	 * 企业信息
	 */
	@ApiField("invoice_company_dto")
	private InvoiceCompanyDTO invoiceCompanyDto;

	/**
	 * 业务平台code, 由发票中台分配
	 */
	@ApiField("platform_code")
	private String platformCode;

	/**
	 * 入驻工单ID
	 */
	@ApiField("register_id")
	private String registerId;

	public List<InvoiceAmountLimitDTO> getAmountLimitDtoList() {
		return this.amountLimitDtoList;
	}
	public void setAmountLimitDtoList(List<InvoiceAmountLimitDTO> amountLimitDtoList) {
		this.amountLimitDtoList = amountLimitDtoList;
	}

	public InvoiceCompanyDTO getInvoiceCompanyDto() {
		return this.invoiceCompanyDto;
	}
	public void setInvoiceCompanyDto(InvoiceCompanyDTO invoiceCompanyDto) {
		this.invoiceCompanyDto = invoiceCompanyDto;
	}

	public String getPlatformCode() {
		return this.platformCode;
	}
	public void setPlatformCode(String platformCode) {
		this.platformCode = platformCode;
	}

	public String getRegisterId() {
		return this.registerId;
	}
	public void setRegisterId(String registerId) {
		this.registerId = registerId;
	}

}
