package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 发票开具结果
 *
 * @author auto create
 * @since 1.0, 2020-06-10 14:04:36
 */
public class InvoiceResultDTO extends AlipayObject {

	private static final long serialVersionUID = 2175544795134878719L;

	/**
	 * 防伪码
	 */
	@ApiField("anti_fake_code")
	private String antiFakeCode;

	/**
	 * 错误编码开票失败时返回
	 */
	@ApiField("biz_error_code")
	private String bizErrorCode;

	/**
	 * 错误信息开票失败时返回
	 */
	@ApiField("biz_error_msg")
	private String bizErrorMsg;

	/**
	 * 发票密文，密码区的字符串
	 */
	@ApiField("ciphertext")
	private String ciphertext;

	/**
	 * 税控设备编号(新版电子发票有)
	 */
	@ApiField("device_no")
	private String deviceNo;

	/**
	 * 错误类型
	 */
	@ApiField("error_type")
	private String errorType;

	/**
	 * 文件类型(pdf,ofd,jpg,png等等)
	 */
	@ApiField("file_data_type")
	private String fileDataType;

	/**
	 * 发票板式文件的下载地址。 一次性下载地址，下载之后地址会失效。 电票开票成功时必须
	 */
	@ApiField("file_path")
	private String filePath;

	/**
	 * 开票金额 开票成功时必须
	 */
	@ApiField("invoice_amount")
	private String invoiceAmount;

	/**
	 * 发票代码 开票成功时必须
	 */
	@ApiField("invoice_code")
	private String invoiceCode;

	/**
	 * 开票日期 开票成功时必须
	 */
	@ApiField("invoice_date")
	private String invoiceDate;

	/**
	 * 开票明细
	 */
	@ApiListField("invoice_items")
	@ApiField("invoice_item_data")
	private List<InvoiceItemData> invoiceItems;

	/**
	 * 发票种类，0=电子发票，1=纸质发票，2=纸质专票
	 */
	@ApiField("invoice_kind")
	private Long invoiceKind;

	/**
	 * 发票号码 开票成功时必须
	 */
	@ApiField("invoice_no")
	private String invoiceNo;

	/**
	 * 开票时间，时分秒格式（注意：2019-04-11之后开具的发票才返回）
	 */
	@ApiField("invoice_time")
	private String invoiceTime;

	/**
	 * 发票类型，blue=蓝票，red=红票
	 */
	@ApiField("invoice_type")
	private String invoiceType;

	/**
	 * 原蓝票发票代码，invoiceType=red时有值
	 */
	@ApiField("normal_invoice_code")
	private String normalInvoiceCode;

	/**
	 * 原蓝票发票号码，invoiceType=red时有值
	 */
	@ApiField("normal_invoice_no")
	private String normalInvoiceNo;

	/**
	 * 复核人
	 */
	@ApiField("payee_checker")
	private String payeeChecker;

	/**
	 * 销售方名称
	 */
	@ApiField("payee_name")
	private String payeeName;

	/**
	 * 开票人
	 */
	@ApiField("payee_operator")
	private String payeeOperator;

	/**
	 * 收款人
	 */
	@ApiField("payee_receiver")
	private String payeeReceiver;

	/**
	 * 销售方税号
	 */
	@ApiField("payee_register_no")
	private String payeeRegisterNo;

	/**
	 * 购买方地址
	 */
	@ApiField("payer_address")
	private String payerAddress;

	/**
	 * 购买方银行账号
	 */
	@ApiField("payer_bankaccount")
	private String payerBankaccount;

	/**
	 * 购买方抬头
	 */
	@ApiField("payer_name")
	private String payerName;

	/**
	 * 购买方电话
	 */
	@ApiField("payer_phone")
	private String payerPhone;

	/**
	 * 购买方税号
	 */
	@ApiField("payer_register_no")
	private String payerRegisterNo;

	/**
	 * 业务平台code, 由发票中台分配
	 */
	@ApiField("platform_code")
	private String platformCode;

	/**
	 * 业务平台对应的订单号
	 */
	@ApiField("platform_tid")
	private String platformTid;

	/**
	 * retrying==true调用方不需要关心，阿里发票中台会自动重试。retrying==false调用方需要处理之后重试。这两类错误阿里发票中台是不会自动重试的：1. 业务错误，比如折扣率计算错误之类的，需要修改报文。2. 税盘错误，比如盘没票了，月初未抄报税等。
	 */
	@ApiField("retrying")
	private Boolean retrying;

	/**
	 * 开票流水号，唯一标志开票请求。如果两次请求流水号相同，则表示重复请求。
	 */
	@ApiField("serial_no")
	private String serialNo;

	/**
	 * 开票状态 (waiting = 开票中) 、(create_success = 开票成功)、(create_failed = 开票失败)
	 */
	@ApiField("status")
	private String status;

	/**
	 * 合计不含税金额，当开红票时，该字段为负数
	 */
	@ApiField("sum_price")
	private String sumPrice;

	/**
	 * 合计税额，当开红票时，该字段为负数
	 */
	@ApiField("sum_tax")
	private String sumTax;

	public String getAntiFakeCode() {
		return this.antiFakeCode;
	}
	public void setAntiFakeCode(String antiFakeCode) {
		this.antiFakeCode = antiFakeCode;
	}

	public String getBizErrorCode() {
		return this.bizErrorCode;
	}
	public void setBizErrorCode(String bizErrorCode) {
		this.bizErrorCode = bizErrorCode;
	}

	public String getBizErrorMsg() {
		return this.bizErrorMsg;
	}
	public void setBizErrorMsg(String bizErrorMsg) {
		this.bizErrorMsg = bizErrorMsg;
	}

	public String getCiphertext() {
		return this.ciphertext;
	}
	public void setCiphertext(String ciphertext) {
		this.ciphertext = ciphertext;
	}

	public String getDeviceNo() {
		return this.deviceNo;
	}
	public void setDeviceNo(String deviceNo) {
		this.deviceNo = deviceNo;
	}

	public String getErrorType() {
		return this.errorType;
	}
	public void setErrorType(String errorType) {
		this.errorType = errorType;
	}

	public String getFileDataType() {
		return this.fileDataType;
	}
	public void setFileDataType(String fileDataType) {
		this.fileDataType = fileDataType;
	}

	public String getFilePath() {
		return this.filePath;
	}
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public String getInvoiceAmount() {
		return this.invoiceAmount;
	}
	public void setInvoiceAmount(String invoiceAmount) {
		this.invoiceAmount = invoiceAmount;
	}

	public String getInvoiceCode() {
		return this.invoiceCode;
	}
	public void setInvoiceCode(String invoiceCode) {
		this.invoiceCode = invoiceCode;
	}

	public String getInvoiceDate() {
		return this.invoiceDate;
	}
	public void setInvoiceDate(String invoiceDate) {
		this.invoiceDate = invoiceDate;
	}

	public List<InvoiceItemData> getInvoiceItems() {
		return this.invoiceItems;
	}
	public void setInvoiceItems(List<InvoiceItemData> invoiceItems) {
		this.invoiceItems = invoiceItems;
	}

	public Long getInvoiceKind() {
		return this.invoiceKind;
	}
	public void setInvoiceKind(Long invoiceKind) {
		this.invoiceKind = invoiceKind;
	}

	public String getInvoiceNo() {
		return this.invoiceNo;
	}
	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}

	public String getInvoiceTime() {
		return this.invoiceTime;
	}
	public void setInvoiceTime(String invoiceTime) {
		this.invoiceTime = invoiceTime;
	}

	public String getInvoiceType() {
		return this.invoiceType;
	}
	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}

	public String getNormalInvoiceCode() {
		return this.normalInvoiceCode;
	}
	public void setNormalInvoiceCode(String normalInvoiceCode) {
		this.normalInvoiceCode = normalInvoiceCode;
	}

	public String getNormalInvoiceNo() {
		return this.normalInvoiceNo;
	}
	public void setNormalInvoiceNo(String normalInvoiceNo) {
		this.normalInvoiceNo = normalInvoiceNo;
	}

	public String getPayeeChecker() {
		return this.payeeChecker;
	}
	public void setPayeeChecker(String payeeChecker) {
		this.payeeChecker = payeeChecker;
	}

	public String getPayeeName() {
		return this.payeeName;
	}
	public void setPayeeName(String payeeName) {
		this.payeeName = payeeName;
	}

	public String getPayeeOperator() {
		return this.payeeOperator;
	}
	public void setPayeeOperator(String payeeOperator) {
		this.payeeOperator = payeeOperator;
	}

	public String getPayeeReceiver() {
		return this.payeeReceiver;
	}
	public void setPayeeReceiver(String payeeReceiver) {
		this.payeeReceiver = payeeReceiver;
	}

	public String getPayeeRegisterNo() {
		return this.payeeRegisterNo;
	}
	public void setPayeeRegisterNo(String payeeRegisterNo) {
		this.payeeRegisterNo = payeeRegisterNo;
	}

	public String getPayerAddress() {
		return this.payerAddress;
	}
	public void setPayerAddress(String payerAddress) {
		this.payerAddress = payerAddress;
	}

	public String getPayerBankaccount() {
		return this.payerBankaccount;
	}
	public void setPayerBankaccount(String payerBankaccount) {
		this.payerBankaccount = payerBankaccount;
	}

	public String getPayerName() {
		return this.payerName;
	}
	public void setPayerName(String payerName) {
		this.payerName = payerName;
	}

	public String getPayerPhone() {
		return this.payerPhone;
	}
	public void setPayerPhone(String payerPhone) {
		this.payerPhone = payerPhone;
	}

	public String getPayerRegisterNo() {
		return this.payerRegisterNo;
	}
	public void setPayerRegisterNo(String payerRegisterNo) {
		this.payerRegisterNo = payerRegisterNo;
	}

	public String getPlatformCode() {
		return this.platformCode;
	}
	public void setPlatformCode(String platformCode) {
		this.platformCode = platformCode;
	}

	public String getPlatformTid() {
		return this.platformTid;
	}
	public void setPlatformTid(String platformTid) {
		this.platformTid = platformTid;
	}

	public Boolean getRetrying() {
		return this.retrying;
	}
	public void setRetrying(Boolean retrying) {
		this.retrying = retrying;
	}

	public String getSerialNo() {
		return this.serialNo;
	}
	public void setSerialNo(String serialNo) {
		this.serialNo = serialNo;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

	public String getSumPrice() {
		return this.sumPrice;
	}
	public void setSumPrice(String sumPrice) {
		this.sumPrice = sumPrice;
	}

	public String getSumTax() {
		return this.sumTax;
	}
	public void setSumTax(String sumTax) {
		this.sumTax = sumTax;
	}

}
