package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 当前用户资源共享的家人查询结果
 *
 * @author auto create
 * @since 1.0, 2021-01-14 10:49:30
 */
public class MySharingUserQueryResult extends AlipayObject {

	private static final long serialVersionUID = 6796172898311459821L;

	/**
	 * 共享的资源内容，芝麻GO家庭卡场景下对应模版ID
	 */
	@ApiField("resource_content")
	private String resourceContent;

	/**
	 * 资源标识
	 */
	@ApiField("resource_id")
	private String resourceId;

	/**
	 * 共享用户绑定的业务方账号ID
	 */
	@ApiField("sharing_user_id")
	private String sharingUserId;

	/**
	 * 共享用户的业务方账号类型
	 */
	@ApiField("sharing_user_type")
	private String sharingUserType;

	public String getResourceContent() {
		return this.resourceContent;
	}
	public void setResourceContent(String resourceContent) {
		this.resourceContent = resourceContent;
	}

	public String getResourceId() {
		return this.resourceId;
	}
	public void setResourceId(String resourceId) {
		this.resourceId = resourceId;
	}

	public String getSharingUserId() {
		return this.sharingUserId;
	}
	public void setSharingUserId(String sharingUserId) {
		this.sharingUserId = sharingUserId;
	}

	public String getSharingUserType() {
		return this.sharingUserType;
	}
	public void setSharingUserType(String sharingUserType) {
		this.sharingUserType = sharingUserType;
	}

}
