package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 根据入参查询账户和流程信息
 *
 * @author auto create
 * @since 1.0, 2021-11-17 14:19:48
 */
public class MybankFinanceBkecgwAccountandflowQueryModel extends AlipayObject {

	private static final long serialVersionUID = 3422388888355216684L;

	/**
	 * 企业证件号,  当cmpInfoMode=CERT_NO  时必须要填写
	 */
	@ApiField("cmp_cert_no")
	private String cmpCertNo;

	/**
	 * 企业信息模式枚举，可传如下三种情况：
  CERT_NO   企业证件号(15位或者18位)
  IP_ROLE_ID  网商会员
  ENTERPRISE_ALIPAY_UID     企业支付宝UID
	 */
	@ApiField("cmp_info_mode")
	private String cmpInfoMode;

	/**
	 * 企业支付宝UID，当cmpInfoMode=ENTERPRISE_ALIPAY_UID时必填
	 */
	@ApiField("enter_prise_alipay_uid")
	private String enterPriseAlipayUid;

	/**
	 * 流程分类(需要查询流程时)
  ENTERPRISE_ALIPAY_OPEN_XIJIN 企支西进流程,查询范围保括老企支、新企支、一键双开
 LEGAL_PERSON_OPEN_XIJIN 法人西进流程,查询范围包括老版法人小微和新版法人小微
	 */
	@ApiField("flow_category")
	private String flowCategory;

	/**
	 * 网商企业会ID, 当cmpInfoMode=IP_ROLE_ID 时必填
	 */
	@ApiField("ip_role_id")
	private String ipRoleId;

	/**
	 * 最近一条流程的模式 (需要查询流程时必填)
  LAST 最近一条流程(包括成功、失败)
  LAST_ON_WAY 最近一条在途流程(不包含成功、失败)
  LAST_WITHOUT_SUCCESS 最近一条流程(不包括成功)
	 */
	@ApiField("last_flow_mode")
	private String lastFlowMode;

	/**
	 * 是否需要查询流程信息，默认是true，表示要查询流程信息
	 */
	@ApiField("need_flow")
	private String needFlow;

	/**
	 * 开户方式枚举 (必填)
  ALL 所有企业账户信息(企支版、法人版、线下)
  XIJIN_LEGAL_PERSON 法人小程序开西进结算户
  XIJIN_ENTERPRISE_ALIPAY 企业支付宝开西进结算户
	 */
	@ApiField("open_acct_way")
	private String openAcctWay;

	/**
	 * 当前操作的支付宝UID(需要查询流程时必填)
	 */
	@ApiField("operator_alipay_uid")
	private String operatorAlipayUid;

	public String getCmpCertNo() {
		return this.cmpCertNo;
	}
	public void setCmpCertNo(String cmpCertNo) {
		this.cmpCertNo = cmpCertNo;
	}

	public String getCmpInfoMode() {
		return this.cmpInfoMode;
	}
	public void setCmpInfoMode(String cmpInfoMode) {
		this.cmpInfoMode = cmpInfoMode;
	}

	public String getEnterPriseAlipayUid() {
		return this.enterPriseAlipayUid;
	}
	public void setEnterPriseAlipayUid(String enterPriseAlipayUid) {
		this.enterPriseAlipayUid = enterPriseAlipayUid;
	}

	public String getFlowCategory() {
		return this.flowCategory;
	}
	public void setFlowCategory(String flowCategory) {
		this.flowCategory = flowCategory;
	}

	public String getIpRoleId() {
		return this.ipRoleId;
	}
	public void setIpRoleId(String ipRoleId) {
		this.ipRoleId = ipRoleId;
	}

	public String getLastFlowMode() {
		return this.lastFlowMode;
	}
	public void setLastFlowMode(String lastFlowMode) {
		this.lastFlowMode = lastFlowMode;
	}

	public String getNeedFlow() {
		return this.needFlow;
	}
	public void setNeedFlow(String needFlow) {
		this.needFlow = needFlow;
	}

	public String getOpenAcctWay() {
		return this.openAcctWay;
	}
	public void setOpenAcctWay(String openAcctWay) {
		this.openAcctWay = openAcctWay;
	}

	public String getOperatorAlipayUid() {
		return this.operatorAlipayUid;
	}
	public void setOperatorAlipayUid(String operatorAlipayUid) {
		this.operatorAlipayUid = operatorAlipayUid;
	}

}
