package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 点餐设置店铺的配置信息
 *
 * @author auto create
 * @since 1.0, 2020-08-05 17:03:25
 */
public class ShopOrderInfo extends AlipayObject {

	private static final long serialVersionUID = 2538189772848515797L;

	/**
	 * 到店点餐开关，OPEN：开启，CLOSED：关闭
	 */
	@ApiField("order_status")
	private String orderStatus;

	/**
	 * 啡快服务时间
	 */
	@ApiField("order_store_business_time")
	private String orderStoreBusinessTime;

	/**
	 * 预点开关，OPEN：开启，CLOSED：关闭
	 */
	@ApiField("pre_order_status")
	private String preOrderStatus;

	/**
	 * 口碑门店ID
	 */
	@ApiField("shop_id")
	private String shopId;

	/**
	 * 线上点餐入口
	 */
	@ApiField("show_order_entry")
	private Boolean showOrderEntry;

	public String getOrderStatus() {
		return this.orderStatus;
	}
	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}

	public String getOrderStoreBusinessTime() {
		return this.orderStoreBusinessTime;
	}
	public void setOrderStoreBusinessTime(String orderStoreBusinessTime) {
		this.orderStoreBusinessTime = orderStoreBusinessTime;
	}

	public String getPreOrderStatus() {
		return this.preOrderStatus;
	}
	public void setPreOrderStatus(String preOrderStatus) {
		this.preOrderStatus = preOrderStatus;
	}

	public String getShopId() {
		return this.shopId;
	}
	public void setShopId(String shopId) {
		this.shopId = shopId;
	}

	public Boolean getShowOrderEntry() {
		return this.showOrderEntry;
	}
	public void setShowOrderEntry(Boolean showOrderEntry) {
		this.showOrderEntry = showOrderEntry;
	}

}
