package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 商米系统确认对应子订单模型
 *
 * @author auto create
 * @since 1.0, 2021-05-24 16:15:24
 */
public class SubOrder extends AlipayObject {

	private static final long serialVersionUID = 1658356925641889281L;

	/**
	 * 屏幕设备信息
	 */
	@ApiField("device")
	private DeviceInstance device;

	/**
	 * device_operate_pic_url 屏幕安装、维修或者回收图片列表
	 */
	@ApiListField("device_operate_pic_url")
	@ApiField("string")
	private List<String> deviceOperatePicUrl;

	/**
	 * device_operate_video_url 屏幕安装、维修或者回收视频列表
	 */
	@ApiListField("device_operate_video_url")
	@ApiField("string")
	private List<String> deviceOperateVideoUrl;

	/**
	 * install_type 屏幕安装方式，1顶挂2壁挂安装时才有
	 */
	@ApiField("install_type")
	private Long installType;

	/**
	 * operate_time 安装或者维修时间
	 */
	@ApiField("operate_time")
	private Date operateTime;

	/**
	 * sub_order_id 唯一 商米工作人员上门服务完，确认订单传的子订单id，从订单里获取子订单id
	 */
	@ApiField("sub_order_id")
	private String subOrderId;

	public DeviceInstance getDevice() {
		return this.device;
	}
	public void setDevice(DeviceInstance device) {
		this.device = device;
	}

	public List<String> getDeviceOperatePicUrl() {
		return this.deviceOperatePicUrl;
	}
	public void setDeviceOperatePicUrl(List<String> deviceOperatePicUrl) {
		this.deviceOperatePicUrl = deviceOperatePicUrl;
	}

	public List<String> getDeviceOperateVideoUrl() {
		return this.deviceOperateVideoUrl;
	}
	public void setDeviceOperateVideoUrl(List<String> deviceOperateVideoUrl) {
		this.deviceOperateVideoUrl = deviceOperateVideoUrl;
	}

	public Long getInstallType() {
		return this.installType;
	}
	public void setInstallType(Long installType) {
		this.installType = installType;
	}

	public Date getOperateTime() {
		return this.operateTime;
	}
	public void setOperateTime(Date operateTime) {
		this.operateTime = operateTime;
	}

	public String getSubOrderId() {
		return this.subOrderId;
	}
	public void setSubOrderId(String subOrderId) {
		this.subOrderId = subOrderId;
	}

}
