package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 留学缴费-付款人信息
 *
 * @author auto create
 * @since 1.0, 2021-10-09 10:06:31
 */
public class TuitionISVPayerInfoDTO extends AlipayObject {

	private static final long serialVersionUID = 5563614893954558353L;

	/**
	 * 支付宝登录号
	 */
	@ApiField("alipay_logon_id")
	private String alipayLogonId;

	/**
	 * 付款人地址
	 */
	@ApiField("payer_address")
	private TuitionAddress payerAddress;

	/**
	 * 付款人身份证号
	 */
	@ApiField("payer_identity_card_number")
	private String payerIdentityCardNumber;

	/**
	 * 付款人姓名
	 */
	@ApiField("payer_name")
	private TuitionUserName payerName;

	/**
	 * 付款人支付宝绑定的手机号
	 */
	@ApiField("payer_phone_number")
	private String payerPhoneNumber;

	public String getAlipayLogonId() {
		return this.alipayLogonId;
	}
	public void setAlipayLogonId(String alipayLogonId) {
		this.alipayLogonId = alipayLogonId;
	}

	public TuitionAddress getPayerAddress() {
		return this.payerAddress;
	}
	public void setPayerAddress(TuitionAddress payerAddress) {
		this.payerAddress = payerAddress;
	}

	public String getPayerIdentityCardNumber() {
		return this.payerIdentityCardNumber;
	}
	public void setPayerIdentityCardNumber(String payerIdentityCardNumber) {
		this.payerIdentityCardNumber = payerIdentityCardNumber;
	}

	public TuitionUserName getPayerName() {
		return this.payerName;
	}
	public void setPayerName(TuitionUserName payerName) {
		this.payerName = payerName;
	}

	public String getPayerPhoneNumber() {
		return this.payerPhoneNumber;
	}
	public void setPayerPhoneNumber(String payerPhoneNumber) {
		this.payerPhoneNumber = payerPhoneNumber;
	}

}
