package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 团油劵订单VO
 *
 * @author auto create
 * @since 1.0, 2020-11-20 11:28:22
 */
public class VoucherOrderVO extends AlipayObject {

	private static final long serialVersionUID = 3349735573969789995L;

	/**
	 * 劵生效时间
	 */
	@ApiField("gmt_active")
	private Date gmtActive;

	/**
	 * 劵创建时间
	 */
	@ApiField("gmt_create")
	private Date gmtCreate;

	/**
	 * 劵失效时间
	 */
	@ApiField("gmt_expired")
	private Date gmtExpired;

	/**
	 * 权益商品ID
	 */
	@ApiField("item_id")
	private String itemId;

	/**
	 * 劵名称
	 */
	@ApiField("name")
	private String name;

	/**
	 * 订单金额
	 */
	@ApiField("order_amount")
	private String orderAmount;

	/**
	 * 订单ID
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 订单状态：
INIT:初始状态
INIT_CLOSE:初始状态关闭
UNPAID:待支付
UNPAID_CLOSE:待支付状态关闭
PAID:已支付
SUCCESS:成功
CLOSED:已关闭
FINISH:完结
	 */
	@ApiField("order_status")
	private String orderStatus;

	/**
	 * 劵模板ID
	 */
	@ApiField("template_id")
	private String templateId;

	/**
	 * 劵面额
	 */
	@ApiField("total_amount")
	private String totalAmount;

	/**
	 * 交易号
	 */
	@ApiField("trade_no")
	private String tradeNo;

	/**
	 * 202010090007300295130003NJIC
	 */
	@ApiField("voucher_id")
	private String voucherId;

	/**
	 * 劵状态：
ENABLED:可用
DISABLED:不可用
UNUSE:未核销
PART_USE:部分核销
ALL_USE:已核销
	 */
	@ApiField("voucher_status")
	private String voucherStatus;

	public Date getGmtActive() {
		return this.gmtActive;
	}
	public void setGmtActive(Date gmtActive) {
		this.gmtActive = gmtActive;
	}

	public Date getGmtCreate() {
		return this.gmtCreate;
	}
	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtExpired() {
		return this.gmtExpired;
	}
	public void setGmtExpired(Date gmtExpired) {
		this.gmtExpired = gmtExpired;
	}

	public String getItemId() {
		return this.itemId;
	}
	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public String getOrderAmount() {
		return this.orderAmount;
	}
	public void setOrderAmount(String orderAmount) {
		this.orderAmount = orderAmount;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOrderStatus() {
		return this.orderStatus;
	}
	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}

	public String getTemplateId() {
		return this.templateId;
	}
	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}

	public String getTotalAmount() {
		return this.totalAmount;
	}
	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}

	public String getTradeNo() {
		return this.tradeNo;
	}
	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}

	public String getVoucherId() {
		return this.voucherId;
	}
	public void setVoucherId(String voucherId) {
		this.voucherId = voucherId;
	}

	public String getVoucherStatus() {
		return this.voucherStatus;
	}
	public void setVoucherStatus(String voucherStatus) {
		this.voucherStatus = voucherStatus;
	}

}
