package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 资金存管服务提现到卡信息
 *
 * @author auto create
 * @since 1.0, 2021-12-04 17:31:18
 */
public class WithdrawBankCardInfoDTO extends AlipayObject {

	private static final long serialVersionUID = 1464858246775742752L;

	/**
	 * 支行联行号
	 */
	@ApiField("bank_branch_org_code")
	private String bankBranchOrgCode;

	/**
	 * 银行侧账单定制信息
	 */
	@ApiField("bank_memo")
	private String bankMemo;

	/**
	 * 卡唯一号
	 */
	@ApiField("card_unique_no")
	private String cardUniqueNo;

	/**
	 * 提现卡类型
	 */
	@ApiField("withdraw_card_type")
	private String withdrawCardType;

	/**
	 * 提现银行账户开户名
	 */
	@ApiField("withdraw_inst_account_name")
	private String withdrawInstAccountName;

	/**
	 * 提现银行账户号
	 */
	@ApiField("withdraw_inst_account_no")
	private String withdrawInstAccountNo;

	/**
	 * 提现账户类别，对公卡，对私卡
	 */
	@ApiField("withdraw_inst_account_type")
	private String withdrawInstAccountType;

	/**
	 * 卡号类型，卡号，索引卡号，卡通协议号
	 */
	@ApiField("withdraw_inst_card_no_type")
	private String withdrawInstCardNoType;

	/**
	 * 提现银行账户开户行ID
	 */
	@ApiField("withdraw_inst_id")
	private String withdrawInstId;

	/**
	 * 协议类型，账户类，协议类
	 */
	@ApiField("withdraw_protocol_type")
	private String withdrawProtocolType;

	/**
	 * 提现时效
	 */
	@ApiField("withdraw_time_lines")
	private String withdrawTimeLines;

	public String getBankBranchOrgCode() {
		return this.bankBranchOrgCode;
	}
	public void setBankBranchOrgCode(String bankBranchOrgCode) {
		this.bankBranchOrgCode = bankBranchOrgCode;
	}

	public String getBankMemo() {
		return this.bankMemo;
	}
	public void setBankMemo(String bankMemo) {
		this.bankMemo = bankMemo;
	}

	public String getCardUniqueNo() {
		return this.cardUniqueNo;
	}
	public void setCardUniqueNo(String cardUniqueNo) {
		this.cardUniqueNo = cardUniqueNo;
	}

	public String getWithdrawCardType() {
		return this.withdrawCardType;
	}
	public void setWithdrawCardType(String withdrawCardType) {
		this.withdrawCardType = withdrawCardType;
	}

	public String getWithdrawInstAccountName() {
		return this.withdrawInstAccountName;
	}
	public void setWithdrawInstAccountName(String withdrawInstAccountName) {
		this.withdrawInstAccountName = withdrawInstAccountName;
	}

	public String getWithdrawInstAccountNo() {
		return this.withdrawInstAccountNo;
	}
	public void setWithdrawInstAccountNo(String withdrawInstAccountNo) {
		this.withdrawInstAccountNo = withdrawInstAccountNo;
	}

	public String getWithdrawInstAccountType() {
		return this.withdrawInstAccountType;
	}
	public void setWithdrawInstAccountType(String withdrawInstAccountType) {
		this.withdrawInstAccountType = withdrawInstAccountType;
	}

	public String getWithdrawInstCardNoType() {
		return this.withdrawInstCardNoType;
	}
	public void setWithdrawInstCardNoType(String withdrawInstCardNoType) {
		this.withdrawInstCardNoType = withdrawInstCardNoType;
	}

	public String getWithdrawInstId() {
		return this.withdrawInstId;
	}
	public void setWithdrawInstId(String withdrawInstId) {
		this.withdrawInstId = withdrawInstId;
	}

	public String getWithdrawProtocolType() {
		return this.withdrawProtocolType;
	}
	public void setWithdrawProtocolType(String withdrawProtocolType) {
		this.withdrawProtocolType = withdrawProtocolType;
	}

	public String getWithdrawTimeLines() {
		return this.withdrawTimeLines;
	}
	public void setWithdrawTimeLines(String withdrawTimeLines) {
		this.withdrawTimeLines = withdrawTimeLines;
	}

}
