package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 取消先享后付记账单
 *
 * @author auto create
 * @since 1.0, 2020-11-14 23:09:11
 */
public class ZhimaMerchantCredituseCreditbillCloseModel extends AlipayObject {

	private static final long serialVersionUID = 5372634812871452185L;

	/**
	 * 本次操作取消的金额，单位为：元（人民币），精确到小数点后两位。
	 */
	@ApiField("amount")
	private String amount;

	/**
	 * 先享后付单号，credit_biz_order_id与out_order_no必传一个
	 */
	@ApiField("credit_biz_order_id")
	private String creditBizOrderId;

	/**
	 * 扩展信息，json格式；
	 */
	@ApiField("extra_param")
	private String extraParam;

	/**
	 * 商户外部单号，credit_biz_order_id与out_order_no必传一个
	 */
	@ApiField("out_order_no")
	private String outOrderNo;

	/**
	 * 商户本次操作的请求流水号，同一商户每次不同的操作请求，商户请求流水号不能重复
	 */
	@ApiField("out_request_no")
	private String outRequestNo;

	/**
	 * 商户对本次取消操作的附言描述
	 */
	@ApiField("remark")
	private String remark;

	public String getAmount() {
		return this.amount;
	}
	public void setAmount(String amount) {
		this.amount = amount;
	}

	public String getCreditBizOrderId() {
		return this.creditBizOrderId;
	}
	public void setCreditBizOrderId(String creditBizOrderId) {
		this.creditBizOrderId = creditBizOrderId;
	}

	public String getExtraParam() {
		return this.extraParam;
	}
	public void setExtraParam(String extraParam) {
		this.extraParam = extraParam;
	}

	public String getOutOrderNo() {
		return this.outOrderNo;
	}
	public void setOutOrderNo(String outOrderNo) {
		this.outOrderNo = outOrderNo;
	}

	public String getOutRequestNo() {
		return this.outRequestNo;
	}
	public void setOutRequestNo(String outRequestNo) {
		this.outRequestNo = outRequestNo;
	}

	public String getRemark() {
		return this.remark;
	}
	public void setRemark(String remark) {
		this.remark = remark;
	}

}
