package com.alipay.api.request;

import com.alipay.api.domain.AntInvoiceItem;
import java.util.Map;

import com.alipay.api.AlipayRequest;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.response.AlipayEbppInvoiceApplyCollectSyncResponse;
import com.alipay.api.AlipayObject;

/**
 * ALIPAY API: alipay.ebpp.invoice.apply.collect.sync request
 * 
 * @author auto create
 * @since 1.0, 2021-04-06 11:44:44
 */
public class AlipayEbppInvoiceApplyCollectSyncRequest implements AlipayRequest<AlipayEbppInvoiceApplyCollectSyncResponse> {

	private AlipayHashMap udfParams; // add user-defined text parameters
	private String apiVersion="1.0";

	/** 
	* 发票防伪码/密码
	 */
	private String antiFakeCode;

	/** 
	* 支付宝发起开票申请的id，该id具有唯一性；回传红票则该字段填写其对应蓝票的申请id
	 */
	private String applyId;

	/** 
	* 发票校验码
	 */
	private String checkCode;

	/** 
	* 合计含税金额（开票金额），格式为2位小数。
当开红票时，该字段为负数。
	 */
	private String invoiceAmount;

	/** 
	* 发票代码
	 */
	private String invoiceCode;

	/** 
	* 开票日期，格式 yyyy-MM-dd
	 */
	private String invoiceDate;

	/** 
	* 发票版式文件数据，base64化的字符串；
电子发票要求必填；
	 */
	private String invoiceFileData;

	/** 
	* 发票版式文件类型，大小写敏感
PDF, OFD。
电票时必传。
	 */
	private String invoiceFileType;

	/** 
	* 发票明细项
	 */
	private AntInvoiceItem invoiceItems;

	/** 
	* 开票发票票种
可选值：
0: 电票普票
1: 纸质普票
2: 纸质专票
	 */
	private String invoiceKind;

	/** 
	* 发票备注
	 */
	private String invoiceMemo;

	/** 
	* 发票号码
	 */
	private String invoiceNo;

	/** 
	* 发票（开票）类型，大小写敏感
可选值：RED：红票, BLUE：蓝票
	 */
	private String invoiceType;

	/** 
	* 原始发票代码（invoice_type=RED时必填）
	 */
	private String normalInvoiceCode;

	/** 
	* 原始发票号码（invoice_type=RED时必填）
	 */
	private String normalInvoiceNo;

	/** 
	* 外部申请id，由开票服务方生成，该id在开票服务方具有唯一性，建议服务商取自身开票申请流水id
	 */
	private String outApplyId;

	/** 
	* 销方地址。
	 */
	private String payeeAddress;

	/** 
	* 销方银行账号。
	 */
	private String payeeBankAccountId;

	/** 
	* 销方开户行名称。
	 */
	private String payeeBankName;

	/** 
	* 复核人
	 */
	private String payeeChecker;

	/** 
	* 销方名称
	 */
	private String payeeName;

	/** 
	* 开票人
	 */
	private String payeeOperator;

	/** 
	* 销方联系电话。
	 */
	private String payeePhone;

	/** 
	* 收款人
	 */
	private String payeeReceiver;

	/** 
	* 销方税务登记证号。由大写字母或数字组成，长度要求15~20位。
	 */
	private String payeeRegisterNo;

	/** 
	* 购方地址，
专票和电子专票必填。
	 */
	private String payerAddress;

	/** 
	* 购方银行账号，
1.专票和电子专票必填
2.和payer_bank_name字段联动，其中一项有值要求都要填写
	 */
	private String payerBankAccountId;

	/** 
	* 购方开户行名称，
1.专票和电子专票必填
2.和字段payer_bank_account_id联动，其中一项有值要求都要填写
	 */
	private String payerBankName;

	/** 
	* 购方抬头
	 */
	private String payerName;

	/** 
	* 购方联系电话，
专票和电子专票必填。
	 */
	private String payerPhone;

	/** 
	* 购方税务登记证号，由大写字母或数字组成，长度要求15~20位。专票和电子发票必填
	 */
	private String payerRegisterNo;

	/** 
	* 特殊票种标识，可选值：
01-区块链发票，
02-农产品收购票，
03-通票
	 */
	private String specialFlag;

	/** 
	* 合计金额（不含税），格式为2位小数。
当开红票时，该字段为负数
	 */
	private String sumPrice;

	/** 
	* 合计税额，格式为2位小数。
当开红票时，该字段为0或负数
	 */
	private String sumTax;

	public void setAntiFakeCode(String antiFakeCode) {
		this.antiFakeCode = antiFakeCode;
	}
	public String getAntiFakeCode() {
		return this.antiFakeCode;
	}

	public void setApplyId(String applyId) {
		this.applyId = applyId;
	}
	public String getApplyId() {
		return this.applyId;
	}

	public void setCheckCode(String checkCode) {
		this.checkCode = checkCode;
	}
	public String getCheckCode() {
		return this.checkCode;
	}

	public void setInvoiceAmount(String invoiceAmount) {
		this.invoiceAmount = invoiceAmount;
	}
	public String getInvoiceAmount() {
		return this.invoiceAmount;
	}

	public void setInvoiceCode(String invoiceCode) {
		this.invoiceCode = invoiceCode;
	}
	public String getInvoiceCode() {
		return this.invoiceCode;
	}

	public void setInvoiceDate(String invoiceDate) {
		this.invoiceDate = invoiceDate;
	}
	public String getInvoiceDate() {
		return this.invoiceDate;
	}

	public void setInvoiceFileData(String invoiceFileData) {
		this.invoiceFileData = invoiceFileData;
	}
	public String getInvoiceFileData() {
		return this.invoiceFileData;
	}

	public void setInvoiceFileType(String invoiceFileType) {
		this.invoiceFileType = invoiceFileType;
	}
	public String getInvoiceFileType() {
		return this.invoiceFileType;
	}

	public void setInvoiceItems(AntInvoiceItem invoiceItems) {
		this.invoiceItems = invoiceItems;
	}
	public AntInvoiceItem getInvoiceItems() {
		return this.invoiceItems;
	}

	public void setInvoiceKind(String invoiceKind) {
		this.invoiceKind = invoiceKind;
	}
	public String getInvoiceKind() {
		return this.invoiceKind;
	}

	public void setInvoiceMemo(String invoiceMemo) {
		this.invoiceMemo = invoiceMemo;
	}
	public String getInvoiceMemo() {
		return this.invoiceMemo;
	}

	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}
	public String getInvoiceNo() {
		return this.invoiceNo;
	}

	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}
	public String getInvoiceType() {
		return this.invoiceType;
	}

	public void setNormalInvoiceCode(String normalInvoiceCode) {
		this.normalInvoiceCode = normalInvoiceCode;
	}
	public String getNormalInvoiceCode() {
		return this.normalInvoiceCode;
	}

	public void setNormalInvoiceNo(String normalInvoiceNo) {
		this.normalInvoiceNo = normalInvoiceNo;
	}
	public String getNormalInvoiceNo() {
		return this.normalInvoiceNo;
	}

	public void setOutApplyId(String outApplyId) {
		this.outApplyId = outApplyId;
	}
	public String getOutApplyId() {
		return this.outApplyId;
	}

	public void setPayeeAddress(String payeeAddress) {
		this.payeeAddress = payeeAddress;
	}
	public String getPayeeAddress() {
		return this.payeeAddress;
	}

	public void setPayeeBankAccountId(String payeeBankAccountId) {
		this.payeeBankAccountId = payeeBankAccountId;
	}
	public String getPayeeBankAccountId() {
		return this.payeeBankAccountId;
	}

	public void setPayeeBankName(String payeeBankName) {
		this.payeeBankName = payeeBankName;
	}
	public String getPayeeBankName() {
		return this.payeeBankName;
	}

	public void setPayeeChecker(String payeeChecker) {
		this.payeeChecker = payeeChecker;
	}
	public String getPayeeChecker() {
		return this.payeeChecker;
	}

	public void setPayeeName(String payeeName) {
		this.payeeName = payeeName;
	}
	public String getPayeeName() {
		return this.payeeName;
	}

	public void setPayeeOperator(String payeeOperator) {
		this.payeeOperator = payeeOperator;
	}
	public String getPayeeOperator() {
		return this.payeeOperator;
	}

	public void setPayeePhone(String payeePhone) {
		this.payeePhone = payeePhone;
	}
	public String getPayeePhone() {
		return this.payeePhone;
	}

	public void setPayeeReceiver(String payeeReceiver) {
		this.payeeReceiver = payeeReceiver;
	}
	public String getPayeeReceiver() {
		return this.payeeReceiver;
	}

	public void setPayeeRegisterNo(String payeeRegisterNo) {
		this.payeeRegisterNo = payeeRegisterNo;
	}
	public String getPayeeRegisterNo() {
		return this.payeeRegisterNo;
	}

	public void setPayerAddress(String payerAddress) {
		this.payerAddress = payerAddress;
	}
	public String getPayerAddress() {
		return this.payerAddress;
	}

	public void setPayerBankAccountId(String payerBankAccountId) {
		this.payerBankAccountId = payerBankAccountId;
	}
	public String getPayerBankAccountId() {
		return this.payerBankAccountId;
	}

	public void setPayerBankName(String payerBankName) {
		this.payerBankName = payerBankName;
	}
	public String getPayerBankName() {
		return this.payerBankName;
	}

	public void setPayerName(String payerName) {
		this.payerName = payerName;
	}
	public String getPayerName() {
		return this.payerName;
	}

	public void setPayerPhone(String payerPhone) {
		this.payerPhone = payerPhone;
	}
	public String getPayerPhone() {
		return this.payerPhone;
	}

	public void setPayerRegisterNo(String payerRegisterNo) {
		this.payerRegisterNo = payerRegisterNo;
	}
	public String getPayerRegisterNo() {
		return this.payerRegisterNo;
	}

	public void setSpecialFlag(String specialFlag) {
		this.specialFlag = specialFlag;
	}
	public String getSpecialFlag() {
		return this.specialFlag;
	}

	public void setSumPrice(String sumPrice) {
		this.sumPrice = sumPrice;
	}
	public String getSumPrice() {
		return this.sumPrice;
	}

	public void setSumTax(String sumTax) {
		this.sumTax = sumTax;
	}
	public String getSumTax() {
		return this.sumTax;
	}
	private String terminalType;
	private String terminalInfo;	
	private String prodCode;
	private String notifyUrl;
	private String returnUrl;
	private boolean needEncrypt=false;
	private AlipayObject bizModel=null;

	public String getNotifyUrl() {
		return this.notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getReturnUrl() {
		return this.returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public String getApiVersion() {
		return this.apiVersion;
	}

	public void setApiVersion(String apiVersion) {
		this.apiVersion = apiVersion;
	}

	public void setTerminalType(String terminalType){
		this.terminalType=terminalType;
	}

    public String getTerminalType(){
    	return this.terminalType;
    }

    public void setTerminalInfo(String terminalInfo){
    	this.terminalInfo=terminalInfo;
    }

    public String getTerminalInfo(){
    	return this.terminalInfo;
    }	

	public void setProdCode(String prodCode) {
		this.prodCode=prodCode;
	}

	public String getProdCode() {
		return this.prodCode; 
	}

	public String getApiMethodName() {
		return "alipay.ebpp.invoice.apply.collect.sync";
	}

	public Map<String, String> getTextParams() {		
		AlipayHashMap txtParams = new AlipayHashMap();
		txtParams.put("anti_fake_code", this.antiFakeCode);
		txtParams.put("apply_id", this.applyId);
		txtParams.put("check_code", this.checkCode);
		txtParams.put("invoice_amount", this.invoiceAmount);
		txtParams.put("invoice_code", this.invoiceCode);
		txtParams.put("invoice_date", this.invoiceDate);
		txtParams.put("invoice_file_data", this.invoiceFileData);
		txtParams.put("invoice_file_type", this.invoiceFileType);
		txtParams.put("invoice_items", this.invoiceItems == null? null : new com.alipay.api.internal.util.json.JSONWriter().write(this.invoiceItems, true));
		txtParams.put("invoice_kind", this.invoiceKind);
		txtParams.put("invoice_memo", this.invoiceMemo);
		txtParams.put("invoice_no", this.invoiceNo);
		txtParams.put("invoice_type", this.invoiceType);
		txtParams.put("normal_invoice_code", this.normalInvoiceCode);
		txtParams.put("normal_invoice_no", this.normalInvoiceNo);
		txtParams.put("out_apply_id", this.outApplyId);
		txtParams.put("payee_address", this.payeeAddress);
		txtParams.put("payee_bank_account_id", this.payeeBankAccountId);
		txtParams.put("payee_bank_name", this.payeeBankName);
		txtParams.put("payee_checker", this.payeeChecker);
		txtParams.put("payee_name", this.payeeName);
		txtParams.put("payee_operator", this.payeeOperator);
		txtParams.put("payee_phone", this.payeePhone);
		txtParams.put("payee_receiver", this.payeeReceiver);
		txtParams.put("payee_register_no", this.payeeRegisterNo);
		txtParams.put("payer_address", this.payerAddress);
		txtParams.put("payer_bank_account_id", this.payerBankAccountId);
		txtParams.put("payer_bank_name", this.payerBankName);
		txtParams.put("payer_name", this.payerName);
		txtParams.put("payer_phone", this.payerPhone);
		txtParams.put("payer_register_no", this.payerRegisterNo);
		txtParams.put("special_flag", this.specialFlag);
		txtParams.put("sum_price", this.sumPrice);
		txtParams.put("sum_tax", this.sumTax);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new AlipayHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Class<AlipayEbppInvoiceApplyCollectSyncResponse> getResponseClass() {
		return AlipayEbppInvoiceApplyCollectSyncResponse.class;
	}
	

    public boolean isNeedEncrypt() {
    
      return this.needEncrypt;
    }


    public void setNeedEncrypt(boolean needEncrypt) {
    
         this.needEncrypt=needEncrypt;
    }
    
    public AlipayObject getBizModel() {
    
      return this.bizModel;
    }


    public void setBizModel(AlipayObject bizModel) {
    
         this.bizModel=bizModel;
    }
	
	
}
