package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.domain.CdbRepayDetail;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.commerce.educate.cdb.repay.query response.
 * 
 * @author auto create
 * @since 1.0, 2020-11-23 11:18:57
 */
public class AlipayCommerceEducateCdbRepayQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 1129896727416415268L;

	/** 
	 * 业务类型 A生源地 B高校
	 */
	@ApiField("biz_type")
	private String bizType;

	/** 
	 * 学生所在分行名称
	 */
	@ApiField("branch_name")
	private String branchName;

	/** 
	 * 学生所在区县或高校
	 */
	@ApiField("org_name")
	private String orgName;

	/** 
	 * 还款日期，格式yyyy-MM-dd
	 */
	@ApiField("repay_date")
	private String repayDate;

	/** 
	 * 还款明细列表
	 */
	@ApiField("repay_list")
	private CdbRepayDetail repayList;

	/** 
	 * 学生当前应还金额汇总
	 */
	@ApiField("should_amount")
	private String shouldAmount;

	/** 
	 * 学生姓名
	 */
	@ApiField("student_name")
	private String studentName;

	public void setBizType(String bizType) {
		this.bizType = bizType;
	}
	public String getBizType( ) {
		return this.bizType;
	}

	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}
	public String getBranchName( ) {
		return this.branchName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}
	public String getOrgName( ) {
		return this.orgName;
	}

	public void setRepayDate(String repayDate) {
		this.repayDate = repayDate;
	}
	public String getRepayDate( ) {
		return this.repayDate;
	}

	public void setRepayList(CdbRepayDetail repayList) {
		this.repayList = repayList;
	}
	public CdbRepayDetail getRepayList( ) {
		return this.repayList;
	}

	public void setShouldAmount(String shouldAmount) {
		this.shouldAmount = shouldAmount;
	}
	public String getShouldAmount( ) {
		return this.shouldAmount;
	}

	public void setStudentName(String studentName) {
		this.studentName = studentName;
	}
	public String getStudentName( ) {
		return this.studentName;
	}

}
