package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.VoucherOrderVO;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.commerce.gas.info.ordercoupon.query response.
 * 
 * @author auto create
 * @since 1.0, 2020-11-23 11:35:01
 */
public class AlipayCommerceGasInfoOrdercouponQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 6496165589754864582L;

	/** 
	 * 当前页码,不填写默认查第1页
	 */
	@ApiField("page_num")
	private String pageNum;

	/** 
	 * 每页显示数量,不填写默认10条
	 */
	@ApiField("page_size")
	private Long pageSize;

	/** 
	 * 总页数
	 */
	@ApiField("total_pages")
	private Long totalPages;

	/** 
	 * 总记录数
	 */
	@ApiField("total_size")
	private Long totalSize;

	/** 
	 * 劵订单列表VO
	 */
	@ApiListField("voucher_orders")
	@ApiField("voucher_order_v_o")
	private List<VoucherOrderVO> voucherOrders;

	public void setPageNum(String pageNum) {
		this.pageNum = pageNum;
	}
	public String getPageNum( ) {
		return this.pageNum;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}
	public Long getPageSize( ) {
		return this.pageSize;
	}

	public void setTotalPages(Long totalPages) {
		this.totalPages = totalPages;
	}
	public Long getTotalPages( ) {
		return this.totalPages;
	}

	public void setTotalSize(Long totalSize) {
		this.totalSize = totalSize;
	}
	public Long getTotalSize( ) {
		return this.totalSize;
	}

	public void setVoucherOrders(List<VoucherOrderVO> voucherOrders) {
		this.voucherOrders = voucherOrders;
	}
	public List<VoucherOrderVO> getVoucherOrders( ) {
		return this.voucherOrders;
	}

}
