package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.EnergyGoodRequest;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.eco.activity.recycle.query response.
 * 
 * @author auto create
 * @since 1.0, 2021-02-04 10:14:53
 */
public class AlipayEcoActivityRecycleQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 3357449948937726874L;

	/** 
	 * 能量发放失败的物品清单，失败可能是因为风控等原因导致的
	 */
	@ApiListField("failed_items")
	@ApiField("energy_good_request")
	private List<EnergyGoodRequest> failedItems;

	/** 
	 * 能量发放成功的物品清单
	 */
	@ApiListField("successful_items")
	@ApiField("energy_good_request")
	private List<EnergyGoodRequest> successfulItems;

	public void setFailedItems(List<EnergyGoodRequest> failedItems) {
		this.failedItems = failedItems;
	}
	public List<EnergyGoodRequest> getFailedItems( ) {
		return this.failedItems;
	}

	public void setSuccessfulItems(List<EnergyGoodRequest> successfulItems) {
		this.successfulItems = successfulItems;
	}
	public List<EnergyGoodRequest> getSuccessfulItems( ) {
		return this.successfulItems;
	}

}
