package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.SignStatusResult;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.fincore.compliance.sign.status.query response.
 * 
 * @author auto create
 * @since 1.0, 2021-12-16 17:28:30
 */
public class AlipayFincoreComplianceSignStatusQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 7261344873633686413L;

	/** 
	 * 业务单据号
	 */
	@ApiField("business_id")
	private String businessId;

	/** 
	 * 用印状态列表
	 */
	@ApiListField("sign_status_result_list")
	@ApiField("sign_status_result")
	private List<SignStatusResult> signStatusResultList;

	/** 
	 * 用印总状态
	 */
	@ApiField("total_status")
	private String totalStatus;

	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}
	public String getBusinessId( ) {
		return this.businessId;
	}

	public void setSignStatusResultList(List<SignStatusResult> signStatusResultList) {
		this.signStatusResultList = signStatusResultList;
	}
	public List<SignStatusResult> getSignStatusResultList( ) {
		return this.signStatusResultList;
	}

	public void setTotalStatus(String totalStatus) {
		this.totalStatus = totalStatus;
	}
	public String getTotalStatus( ) {
		return this.totalStatus;
	}

}
