package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.AppAuthToken;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.open.auth.appauth.query response.
 * 
 * @author auto create
 * @since 1.0, 2020-12-03 14:00:56
 */
public class AlipayOpenAuthAppauthQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 5196651997311297499L;

	/** 
	 * 应用授权令牌列表
	 */
	@ApiListField("app_auth_token_list")
	@ApiField("app_auth_token")
	private List<AppAuthToken> appAuthTokenList;

	/** 
	 * 分页查询的当前页码
	 */
	@ApiField("page_no")
	private Long pageNo;

	/** 
	 * 分页查询的单页条目数
	 */
	@ApiField("page_size")
	private String pageSize;

	/** 
	 * 符合查询条件的总条目数
	 */
	@ApiField("query_total_item")
	private Long queryTotalItem;

	/** 
	 * 分页查询的总页数
	 */
	@ApiField("total_pages")
	private Long totalPages;

	public void setAppAuthTokenList(List<AppAuthToken> appAuthTokenList) {
		this.appAuthTokenList = appAuthTokenList;
	}
	public List<AppAuthToken> getAppAuthTokenList( ) {
		return this.appAuthTokenList;
	}

	public void setPageNo(Long pageNo) {
		this.pageNo = pageNo;
	}
	public Long getPageNo( ) {
		return this.pageNo;
	}

	public void setPageSize(String pageSize) {
		this.pageSize = pageSize;
	}
	public String getPageSize( ) {
		return this.pageSize;
	}

	public void setQueryTotalItem(Long queryTotalItem) {
		this.queryTotalItem = queryTotalItem;
	}
	public Long getQueryTotalItem( ) {
		return this.queryTotalItem;
	}

	public void setTotalPages(Long totalPages) {
		this.totalPages = totalPages;
	}
	public Long getTotalPages( ) {
		return this.totalPages;
	}

}
