package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.SharePeerPayTradeInfo;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.pay.paysharingprod.sharepeerpay.preconsult response.
 * 
 * @author auto create
 * @since 1.0, 2021-12-06 11:21:11
 */
public class AlipayPayPaysharingprodSharepeerpayPreconsultResponse extends AlipayResponse {

	private static final long serialVersionUID = 4525417524727322437L;

	/** 
	 * 申请人头像链接
	 */
	@ApiField("applyer_avatar")
	private String applyerAvatar;

	/** 
	 * 申请人支付宝用户昵称
	 */
	@ApiField("applyer_nick_name")
	private String applyerNickName;

	/** 
	 * 申请人脱敏真实姓名
	 */
	@ApiField("applyer_user_name")
	private String applyerUserName;

	/** 
	 * 业务类型
	 */
	@ApiField("biz_type")
	private String bizType;

	/** 
	 * 是否代付文案提示信息区域
	 */
	@ApiField("is_show_copywriting")
	private Boolean isShowCopywriting;

	/** 
	 * 是否展示付款按钮
	 */
	@ApiField("is_show_pay_button")
	private Boolean isShowPayButton;

	/** 
	 * 是否展示代付单状态
	 */
	@ApiField("is_show_peer_pay_status")
	private Boolean isShowPeerPayStatus;

	/** 
	 * 代付单号
	 */
	@ApiField("peer_pay_no")
	private String peerPayNo;

	/** 
	 * 代付状态提示信息
	 */
	@ApiField("peer_pay_notice_info")
	private String peerPayNoticeInfo;

	/** 
	 * 用于展示代付单金额
	 */
	@ApiField("real_amount")
	private String realAmount;

	/** 
	 * 代付人返回支付宝打开的页面地址
	 */
	@ApiField("return_to_alipay_url")
	private String returnToAlipayUrl;

	/** 
	 * 申请人请求代付文案
	 */
	@ApiField("slogan")
	private String slogan;

	/** 
	 * 交易信息列表
	 */
	@ApiListField("trade_info_list")
	@ApiField("share_peer_pay_trade_info")
	private List<SharePeerPayTradeInfo> tradeInfoList;

	public void setApplyerAvatar(String applyerAvatar) {
		this.applyerAvatar = applyerAvatar;
	}
	public String getApplyerAvatar( ) {
		return this.applyerAvatar;
	}

	public void setApplyerNickName(String applyerNickName) {
		this.applyerNickName = applyerNickName;
	}
	public String getApplyerNickName( ) {
		return this.applyerNickName;
	}

	public void setApplyerUserName(String applyerUserName) {
		this.applyerUserName = applyerUserName;
	}
	public String getApplyerUserName( ) {
		return this.applyerUserName;
	}

	public void setBizType(String bizType) {
		this.bizType = bizType;
	}
	public String getBizType( ) {
		return this.bizType;
	}

	public void setIsShowCopywriting(Boolean isShowCopywriting) {
		this.isShowCopywriting = isShowCopywriting;
	}
	public Boolean getIsShowCopywriting( ) {
		return this.isShowCopywriting;
	}

	public void setIsShowPayButton(Boolean isShowPayButton) {
		this.isShowPayButton = isShowPayButton;
	}
	public Boolean getIsShowPayButton( ) {
		return this.isShowPayButton;
	}

	public void setIsShowPeerPayStatus(Boolean isShowPeerPayStatus) {
		this.isShowPeerPayStatus = isShowPeerPayStatus;
	}
	public Boolean getIsShowPeerPayStatus( ) {
		return this.isShowPeerPayStatus;
	}

	public void setPeerPayNo(String peerPayNo) {
		this.peerPayNo = peerPayNo;
	}
	public String getPeerPayNo( ) {
		return this.peerPayNo;
	}

	public void setPeerPayNoticeInfo(String peerPayNoticeInfo) {
		this.peerPayNoticeInfo = peerPayNoticeInfo;
	}
	public String getPeerPayNoticeInfo( ) {
		return this.peerPayNoticeInfo;
	}

	public void setRealAmount(String realAmount) {
		this.realAmount = realAmount;
	}
	public String getRealAmount( ) {
		return this.realAmount;
	}

	public void setReturnToAlipayUrl(String returnToAlipayUrl) {
		this.returnToAlipayUrl = returnToAlipayUrl;
	}
	public String getReturnToAlipayUrl( ) {
		return this.returnToAlipayUrl;
	}

	public void setSlogan(String slogan) {
		this.slogan = slogan;
	}
	public String getSlogan( ) {
		return this.slogan;
	}

	public void setTradeInfoList(List<SharePeerPayTradeInfo> tradeInfoList) {
		this.tradeInfoList = tradeInfoList;
	}
	public List<SharePeerPayTradeInfo> getTradeInfoList( ) {
		return this.tradeInfoList;
	}

}
