package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.user.digitalidentity.sdkdoc.get response.
 * 
 * @author auto create
 * @since 1.0, 2020-09-10 16:29:06
 */
public class AlipayUserDigitalidentitySdkdocGetResponse extends AlipayResponse {

	private static final long serialVersionUID = 8377882951822216343L;

	/** 
	 * 详细地址，仅行驶证会返回此字段
	 */
	@ApiField("address")
	private String address;

	/** 
	 * 证件号
	 */
	@ApiField("cert_no")
	private String certNo;

	/** 
	 * 输出的证件类型
目前有:IDENTITY_CARD(身份证)，VEHICLE_LICENSE(行驶证)
	 */
	@ApiField("doc_type")
	private String docType;

	/** 
	 * 发动机号码，仅行驶证会返回此字段
	 */
	@ApiField("engine_no")
	private String engineNo;

	/** 
	 * 车辆品牌型号，仅行驶证会返回此字段
	 */
	@ApiField("model")
	private String model;

	/** 
	 * 证件对应的用户姓名
	 */
	@ApiField("name")
	private String name;

	/** 
	 * 所属人，仅行驶证会返回此字段
	 */
	@ApiField("owner")
	private String owner;

	/** 
	 * 证件签发时间，仅行驶证会返回此字段
	 */
	@ApiField("register_date")
	private String registerDate;

	/** 
	 * 车辆使用性质，仅行驶证会返回此字段
	 */
	@ApiField("use_character")
	private String useCharacter;

	/** 
	 * 车辆类型，仅行驶证会返回此字段
	 */
	@ApiField("vehicle_type")
	private String vehicleType;

	/** 
	 * 车辆识别代码，仅行驶证会返回此字段
	 */
	@ApiField("vin")
	private String vin;

	public void setAddress(String address) {
		this.address = address;
	}
	public String getAddress( ) {
		return this.address;
	}

	public void setCertNo(String certNo) {
		this.certNo = certNo;
	}
	public String getCertNo( ) {
		return this.certNo;
	}

	public void setDocType(String docType) {
		this.docType = docType;
	}
	public String getDocType( ) {
		return this.docType;
	}

	public void setEngineNo(String engineNo) {
		this.engineNo = engineNo;
	}
	public String getEngineNo( ) {
		return this.engineNo;
	}

	public void setModel(String model) {
		this.model = model;
	}
	public String getModel( ) {
		return this.model;
	}

	public void setName(String name) {
		this.name = name;
	}
	public String getName( ) {
		return this.name;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}
	public String getOwner( ) {
		return this.owner;
	}

	public void setRegisterDate(String registerDate) {
		this.registerDate = registerDate;
	}
	public String getRegisterDate( ) {
		return this.registerDate;
	}

	public void setUseCharacter(String useCharacter) {
		this.useCharacter = useCharacter;
	}
	public String getUseCharacter( ) {
		return this.useCharacter;
	}

	public void setVehicleType(String vehicleType) {
		this.vehicleType = vehicleType;
	}
	public String getVehicleType( ) {
		return this.vehicleType;
	}

	public void setVin(String vin) {
		this.vin = vin;
	}
	public String getVin( ) {
		return this.vin;
	}

}
