package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.domain.AlipayMiniCardData;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.user.member.alipaycard.query response.
 * 
 * @author auto create
 * @since 1.0, 2021-07-13 10:41:54
 */
public class AlipayUserMemberAlipaycardQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 8527936798448283989L;

	/** 
	 * 支付宝卡片展现信息（缓存）
	 */
	@ApiField("alipay_card_cache_data")
	private AlipayMiniCardData alipayCardCacheData;

	/** 
	 * 支付宝卡片展现信息（实时），展现层数据信息，结构详见具体复杂类型，返回给用户的卡片展现信息包括实时类和缓存类两部分，缓存类是对实时性要求不高的透出内容。实时类是精确信息，直接用于前端展现，缓存类用于存在缓存中，在调用接口超时或者降级时取用。
	 */
	@ApiField("alipay_card_real_time_data")
	private AlipayMiniCardData alipayCardRealTimeData;

	/** 
	 * 可存入缓存的卡片展示信息
	 */
	@ApiField("backup_display_info")
	private String backupDisplayInfo;

	/** 
	 * 工具类或卡片类，single_tool或single_content
	 */
	@ApiField("backup_template_code")
	private String backupTemplateCode;

	/** 
	 * 植入在手淘的埋点信息
	 */
	@ApiField("backup_track_info")
	private String backupTrackInfo;

	/** 
	 * 按照淘宝约定的格式返回的卡片展示结果，json格式
	 */
	@ApiField("display_info")
	private String displayInfo;

	/** 
	 * 扩展字段，备用
	 */
	@ApiField("ext_info")
	private String extInfo;

	/** 
	 * 工具类或卡片类，single_tool或single_content
	 */
	@ApiField("template_code")
	private String templateCode;

	/** 
	 * 植入在手淘的埋点信息
	 */
	@ApiField("track_info")
	private String trackInfo;

	public void setAlipayCardCacheData(AlipayMiniCardData alipayCardCacheData) {
		this.alipayCardCacheData = alipayCardCacheData;
	}
	public AlipayMiniCardData getAlipayCardCacheData( ) {
		return this.alipayCardCacheData;
	}

	public void setAlipayCardRealTimeData(AlipayMiniCardData alipayCardRealTimeData) {
		this.alipayCardRealTimeData = alipayCardRealTimeData;
	}
	public AlipayMiniCardData getAlipayCardRealTimeData( ) {
		return this.alipayCardRealTimeData;
	}

	public void setBackupDisplayInfo(String backupDisplayInfo) {
		this.backupDisplayInfo = backupDisplayInfo;
	}
	public String getBackupDisplayInfo( ) {
		return this.backupDisplayInfo;
	}

	public void setBackupTemplateCode(String backupTemplateCode) {
		this.backupTemplateCode = backupTemplateCode;
	}
	public String getBackupTemplateCode( ) {
		return this.backupTemplateCode;
	}

	public void setBackupTrackInfo(String backupTrackInfo) {
		this.backupTrackInfo = backupTrackInfo;
	}
	public String getBackupTrackInfo( ) {
		return this.backupTrackInfo;
	}

	public void setDisplayInfo(String displayInfo) {
		this.displayInfo = displayInfo;
	}
	public String getDisplayInfo( ) {
		return this.displayInfo;
	}

	public void setExtInfo(String extInfo) {
		this.extInfo = extInfo;
	}
	public String getExtInfo( ) {
		return this.extInfo;
	}

	public void setTemplateCode(String templateCode) {
		this.templateCode = templateCode;
	}
	public String getTemplateCode( ) {
		return this.templateCode;
	}

	public void setTrackInfo(String trackInfo) {
		this.trackInfo = trackInfo;
	}
	public String getTrackInfo( ) {
		return this.trackInfo;
	}

}
