package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: antfortune.stock.customer.info.query response.
 * 
 * @author auto create
 * @since 1.0, 2020-08-27 10:08:20
 */
public class AntfortuneStockCustomerInfoQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 5591892894399622969L;

	/** 
	 * 用户详细地址
	 */
	@ApiField("address")
	private String address;

	/** 
	 * 标记蚂蚁用户uid和各家券商之间唯一关联关系的id标识
	 */
	@ApiField("agreement_no")
	private String agreementNo;

	/** 
	 * 银行名称
	 */
	@ApiField("bank")
	private String bank;

	/** 
	 * 银行卡号
	 */
	@ApiField("bank_card_no")
	private String bankCardNo;

	/** 
	 * 身份证正面图片-base64编码
	 */
	@ApiField("cert_face_img")
	private String certFaceImg;

	/** 
	 * 证件号
	 */
	@ApiField("cert_no")
	private String certNo;

	/** 
	 * 证件类型
	 */
	@ApiField("cert_type")
	private String certType;

	/** 
	 * 身份证有效期结束时间
	 */
	@ApiField("cert_valid_end")
	private String certValidEnd;

	/** 
	 * 身份证有效期起始时间
	 */
	@ApiField("cert_valid_start")
	private String certValidStart;

	/** 
	 * 身份证背面图片-base64编码
	 */
	@ApiField("cert_verso_img")
	private String certVersoImg;

	/** 
	 * 城市名称
	 */
	@ApiField("city")
	private String city;

	/** 
	 * 学历
	 */
	@ApiField("degree")
	private String degree;

	/** 
	 * 扩展字段，JsonString
	 */
	@ApiField("extension")
	private String extension;

	/** 
	 * 职业
	 */
	@ApiField("profession")
	private String profession;

	/** 
	 * 省份名称
	 */
	@ApiField("province")
	private String province;

	/** 
	 * 真实姓名
	 */
	@ApiField("real_name")
	private String realName;

	/** 
	 * 结果码（错误码）
	 */
	@ApiField("result_code")
	private String resultCode;

	/** 
	 * 错误描述；结果状态为F/U时必填
	 */
	@ApiField("result_msg")
	private String resultMsg;

	/** 
	 * 调用结果状态，S/F/U 成功、失败、未知
	 */
	@ApiField("result_status")
	private String resultStatus;

	/** 
	 * 邮政编码
	 */
	@ApiField("zip")
	private String zip;

	public void setAddress(String address) {
		this.address = address;
	}
	public String getAddress( ) {
		return this.address;
	}

	public void setAgreementNo(String agreementNo) {
		this.agreementNo = agreementNo;
	}
	public String getAgreementNo( ) {
		return this.agreementNo;
	}

	public void setBank(String bank) {
		this.bank = bank;
	}
	public String getBank( ) {
		return this.bank;
	}

	public void setBankCardNo(String bankCardNo) {
		this.bankCardNo = bankCardNo;
	}
	public String getBankCardNo( ) {
		return this.bankCardNo;
	}

	public void setCertFaceImg(String certFaceImg) {
		this.certFaceImg = certFaceImg;
	}
	public String getCertFaceImg( ) {
		return this.certFaceImg;
	}

	public void setCertNo(String certNo) {
		this.certNo = certNo;
	}
	public String getCertNo( ) {
		return this.certNo;
	}

	public void setCertType(String certType) {
		this.certType = certType;
	}
	public String getCertType( ) {
		return this.certType;
	}

	public void setCertValidEnd(String certValidEnd) {
		this.certValidEnd = certValidEnd;
	}
	public String getCertValidEnd( ) {
		return this.certValidEnd;
	}

	public void setCertValidStart(String certValidStart) {
		this.certValidStart = certValidStart;
	}
	public String getCertValidStart( ) {
		return this.certValidStart;
	}

	public void setCertVersoImg(String certVersoImg) {
		this.certVersoImg = certVersoImg;
	}
	public String getCertVersoImg( ) {
		return this.certVersoImg;
	}

	public void setCity(String city) {
		this.city = city;
	}
	public String getCity( ) {
		return this.city;
	}

	public void setDegree(String degree) {
		this.degree = degree;
	}
	public String getDegree( ) {
		return this.degree;
	}

	public void setExtension(String extension) {
		this.extension = extension;
	}
	public String getExtension( ) {
		return this.extension;
	}

	public void setProfession(String profession) {
		this.profession = profession;
	}
	public String getProfession( ) {
		return this.profession;
	}

	public void setProvince(String province) {
		this.province = province;
	}
	public String getProvince( ) {
		return this.province;
	}

	public void setRealName(String realName) {
		this.realName = realName;
	}
	public String getRealName( ) {
		return this.realName;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}
	public String getResultCode( ) {
		return this.resultCode;
	}

	public void setResultMsg(String resultMsg) {
		this.resultMsg = resultMsg;
	}
	public String getResultMsg( ) {
		return this.resultMsg;
	}

	public void setResultStatus(String resultStatus) {
		this.resultStatus = resultStatus;
	}
	public String getResultStatus( ) {
		return this.resultStatus;
	}

	public void setZip(String zip) {
		this.zip = zip;
	}
	public String getZip( ) {
		return this.zip;
	}

}
