/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.util.asymmetric;

import com.alipay.api.AlipayApiErrorEnum;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.asymmetric.IAsymmetricEncryptor;
import java.io.UnsupportedEncodingException;

public abstract class BaseAsymmetricEncryptor
implements IAsymmetricEncryptor {
    private static String DEFAULT_CHARSET = "UTF-8";

    public String decrypt(String cipherTextBase64, String charset, String privateKey) throws AlipayApiException {
        try {
            if (StringUtils.isEmpty(cipherTextBase64)) {
                throw new AlipayApiException(AlipayApiErrorEnum.ENCRYPT_TEXT_EMPTY_ERROR);
            }
            if (StringUtils.isEmpty(privateKey)) {
                throw new AlipayApiException(AlipayApiErrorEnum.SIGN_PRIVATE_KEY_EMPTY_ERROR);
            }
            if (StringUtils.isEmpty(charset)) {
                charset = DEFAULT_CHARSET;
            }
            return this.doDecrypt(cipherTextBase64, charset, privateKey);
        }
        catch (Exception e) {
            String errorMessage = String.format(AlipayApiErrorEnum.DECRYPT_ERROR.getErrMsg(), this.getAsymmetricType(), e.getMessage(), cipherTextBase64, charset, privateKey == null ? 0 : privateKey.length());
            throw new AlipayApiException(errorMessage, (Throwable)e);
        }
    }

    public String encrypt(String plainText, String charset, String publicKey) throws AlipayApiException {
        try {
            if (StringUtils.isEmpty(plainText)) {
                throw new AlipayApiException(AlipayApiErrorEnum.ENCRYPT_TEXT_EMPTY_ERROR);
            }
            if (StringUtils.isEmpty(publicKey)) {
                throw new AlipayApiException(AlipayApiErrorEnum.SIGN_PUBLIC_KEY_EMPTY_ERROR);
            }
            if (StringUtils.isEmpty(charset)) {
                charset = DEFAULT_CHARSET;
            }
            return this.doEncrypt(plainText, charset, publicKey);
        }
        catch (Exception e) {
            String errorMessage = String.format(AlipayApiErrorEnum.ENCRYPT_ERROR.getErrMsg(), this.getAsymmetricType(), e.getMessage(), plainText, charset, publicKey);
            throw new AlipayApiException(errorMessage, (Throwable)e);
        }
    }

    public String sign(String content, String charset, String privateKey) throws AlipayApiException {
        try {
            if (StringUtils.isEmpty(content)) {
                throw new AlipayApiException(AlipayApiErrorEnum.SIGN_TEXT_EMPTY_ERROR);
            }
            if (StringUtils.isEmpty(privateKey)) {
                throw new AlipayApiException(AlipayApiErrorEnum.SIGN_PRIVATE_KEY_EMPTY_ERROR);
            }
            if (StringUtils.isEmpty(charset)) {
                charset = DEFAULT_CHARSET;
            }
            return this.doSign(content, charset, privateKey);
        }
        catch (UnsupportedEncodingException e) {
            String errorMessage = String.format(AlipayApiErrorEnum.SIGN_CHARSET_ERROR.getErrMsg(), this.getAsymmetricType(), charset);
            throw new AlipayApiException(errorMessage, (Throwable)e);
        }
        catch (Exception e) {
            String errorMessage = String.format(AlipayApiErrorEnum.SIGN_ERROR.getErrMsg(), this.getAsymmetricType(), e.getMessage(), content, charset, privateKey == null ? 0 : privateKey.length());
            throw new AlipayApiException(errorMessage, (Throwable)e);
        }
    }

    public boolean verify(String content, String charset, String publicKey, String sign) throws AlipayApiException {
        try {
            if (StringUtils.isEmpty(content)) {
                throw new AlipayApiException(AlipayApiErrorEnum.VERIFY_TEXT_EMPTY_ERROR);
            }
            if (StringUtils.isEmpty(publicKey)) {
                throw new AlipayApiException(AlipayApiErrorEnum.SIGN_PUBLIC_KEY_EMPTY_ERROR);
            }
            if (StringUtils.isEmpty(sign)) {
                throw new AlipayApiException(AlipayApiErrorEnum.SIGN_EMPTY_ERROR);
            }
            if (StringUtils.isEmpty(charset)) {
                charset = DEFAULT_CHARSET;
            }
            return this.doVerify(content, charset, publicKey, sign);
        }
        catch (Exception e) {
            String errorMessage = String.format(AlipayApiErrorEnum.VERIFY_ERROR.getErrMsg(), this.getAsymmetricType(), e.getMessage(), content, charset, publicKey);
            throw new AlipayApiException(errorMessage, (Throwable)e);
        }
    }

    protected abstract String doDecrypt(String var1, String var2, String var3) throws Exception;

    protected abstract String doEncrypt(String var1, String var2, String var3) throws Exception;

    protected abstract String doSign(String var1, String var2, String var3) throws Exception;

    protected abstract boolean doVerify(String var1, String var2, String var3, String var4) throws Exception;

    protected abstract String getAsymmetricType();
}

