/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateServiceConnectionRequest
extends Request {
    @Path
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Body
    @NameInMap(value="authType")
    @Validation(required=true)
    private String authType;
    @Body
    @NameInMap(value="connectionName")
    @Validation(required=true)
    private String connectionName;
    @Body
    @NameInMap(value="connectionType")
    @Validation(required=true)
    private String connectionType;
    @Body
    @NameInMap(value="scope")
    @Validation(required=true)
    private String scope;
    @Body
    @NameInMap(value="serviceAuthId")
    @Validation(required=true)
    private Long serviceAuthId;

    private CreateServiceConnectionRequest(Builder builder) {
        super((Request.Builder)builder);
        this.organizationId = builder.organizationId;
        this.authType = builder.authType;
        this.connectionName = builder.connectionName;
        this.connectionType = builder.connectionType;
        this.scope = builder.scope;
        this.serviceAuthId = builder.serviceAuthId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateServiceConnectionRequest create() {
        return CreateServiceConnectionRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public String getScope() {
        return this.scope;
    }

    public Long getServiceAuthId() {
        return this.serviceAuthId;
    }

    public static final class Builder
    extends Request.Builder<CreateServiceConnectionRequest, Builder> {
        private String organizationId;
        private String authType;
        private String connectionName;
        private String connectionType;
        private String scope;
        private Long serviceAuthId;

        private Builder() {
        }

        private Builder(CreateServiceConnectionRequest request) {
            super((Request)request);
            this.organizationId = request.organizationId;
            this.authType = request.authType;
            this.connectionName = request.connectionName;
            this.connectionType = request.connectionType;
            this.scope = request.scope;
            this.serviceAuthId = request.serviceAuthId;
        }

        public Builder organizationId(String organizationId) {
            this.putPathParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder authType(String authType) {
            this.putBodyParameter("authType", authType);
            this.authType = authType;
            return this;
        }

        public Builder connectionName(String connectionName) {
            this.putBodyParameter("connectionName", connectionName);
            this.connectionName = connectionName;
            return this;
        }

        public Builder connectionType(String connectionType) {
            this.putBodyParameter("connectionType", connectionType);
            this.connectionType = connectionType;
            return this;
        }

        public Builder scope(String scope) {
            this.putBodyParameter("scope", scope);
            this.scope = scope;
            return this;
        }

        public Builder serviceAuthId(Long serviceAuthId) {
            this.putBodyParameter("serviceAuthId", serviceAuthId);
            this.serviceAuthId = serviceAuthId;
            return this;
        }

        public CreateServiceConnectionRequest build() {
            return new CreateServiceConnectionRequest(this);
        }
    }
}

