/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateUserKeyRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Body
    @NameInMap(value="expireTime")
    private String expireTime;
    @Body
    @NameInMap(value="keyScope")
    @Validation(required=true)
    private String keyScope;
    @Body
    @NameInMap(value="publicKey")
    @Validation(required=true)
    private String publicKey;
    @Body
    @NameInMap(value="title")
    @Validation(required=true)
    private String title;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;

    private CreateUserKeyRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.expireTime = builder.expireTime;
        this.keyScope = builder.keyScope;
        this.publicKey = builder.publicKey;
        this.title = builder.title;
        this.organizationId = builder.organizationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateUserKeyRequest create() {
        return CreateUserKeyRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public String getKeyScope() {
        return this.keyScope;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getTitle() {
        return this.title;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public static final class Builder
    extends Request.Builder<CreateUserKeyRequest, Builder> {
        private String accessToken;
        private String expireTime;
        private String keyScope;
        private String publicKey;
        private String title;
        private String organizationId;

        private Builder() {
        }

        private Builder(CreateUserKeyRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.expireTime = request.expireTime;
            this.keyScope = request.keyScope;
            this.publicKey = request.publicKey;
            this.title = request.title;
            this.organizationId = request.organizationId;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder expireTime(String expireTime) {
            this.putBodyParameter("expireTime", expireTime);
            this.expireTime = expireTime;
            return this;
        }

        public Builder keyScope(String keyScope) {
            this.putBodyParameter("keyScope", keyScope);
            this.keyScope = keyScope;
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.putBodyParameter("publicKey", publicKey);
            this.publicKey = publicKey;
            return this;
        }

        public Builder title(String title) {
            this.putBodyParameter("title", title);
            this.title = title;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public CreateUserKeyRequest build() {
            return new CreateUserKeyRequest(this);
        }
    }
}

