/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DeleteRepositoryMemberRequest
extends Request {
    @Path
    @NameInMap(value="repositoryId")
    @Validation(required=true)
    private Long repositoryId;
    @Path
    @NameInMap(value="aliyunPk")
    @Validation(required=true)
    private String aliyunPk;
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Body
    @NameInMap(value="memberType")
    private String memberType;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;

    private DeleteRepositoryMemberRequest(Builder builder) {
        super((Request.Builder)builder);
        this.repositoryId = builder.repositoryId;
        this.aliyunPk = builder.aliyunPk;
        this.accessToken = builder.accessToken;
        this.memberType = builder.memberType;
        this.organizationId = builder.organizationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DeleteRepositoryMemberRequest create() {
        return DeleteRepositoryMemberRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getRepositoryId() {
        return this.repositoryId;
    }

    public String getAliyunPk() {
        return this.aliyunPk;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getMemberType() {
        return this.memberType;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public static final class Builder
    extends Request.Builder<DeleteRepositoryMemberRequest, Builder> {
        private Long repositoryId;
        private String aliyunPk;
        private String accessToken;
        private String memberType;
        private String organizationId;

        private Builder() {
        }

        private Builder(DeleteRepositoryMemberRequest request) {
            super((Request)request);
            this.repositoryId = request.repositoryId;
            this.aliyunPk = request.aliyunPk;
            this.accessToken = request.accessToken;
            this.memberType = request.memberType;
            this.organizationId = request.organizationId;
        }

        public Builder repositoryId(Long repositoryId) {
            this.putPathParameter("repositoryId", repositoryId);
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder aliyunPk(String aliyunPk) {
            this.putPathParameter("aliyunPk", aliyunPk);
            this.aliyunPk = aliyunPk;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder memberType(String memberType) {
            this.putBodyParameter("memberType", memberType);
            this.memberType = memberType;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public DeleteRepositoryMemberRequest build() {
            return new DeleteRepositoryMemberRequest(this);
        }
    }
}

