/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DeleteResourceMemberRequest
extends Request {
    @Path
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Path
    @NameInMap(value="resourceType")
    @Validation(required=true, maximum=9.99999999999999E14, minimum=1.0)
    private String resourceType;
    @Path
    @NameInMap(value="resourceId")
    @Validation(required=true)
    private Long resourceId;
    @Path
    @NameInMap(value="accountId")
    @Validation(required=true)
    private String accountId;

    private DeleteResourceMemberRequest(Builder builder) {
        super((Request.Builder)builder);
        this.organizationId = builder.organizationId;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.accountId = builder.accountId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DeleteResourceMemberRequest create() {
        return DeleteResourceMemberRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Long getResourceId() {
        return this.resourceId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public static final class Builder
    extends Request.Builder<DeleteResourceMemberRequest, Builder> {
        private String organizationId;
        private String resourceType;
        private Long resourceId;
        private String accountId;

        private Builder() {
        }

        private Builder(DeleteResourceMemberRequest request) {
            super((Request)request);
            this.organizationId = request.organizationId;
            this.resourceType = request.resourceType;
            this.resourceId = request.resourceId;
            this.accountId = request.accountId;
        }

        public Builder organizationId(String organizationId) {
            this.putPathParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.putPathParameter("resourceType", resourceType);
            this.resourceType = resourceType;
            return this;
        }

        public Builder resourceId(Long resourceId) {
            this.putPathParameter("resourceId", resourceId);
            this.resourceId = resourceId;
            return this;
        }

        public Builder accountId(String accountId) {
            this.putPathParameter("accountId", accountId);
            this.accountId = accountId;
            return this;
        }

        public DeleteResourceMemberRequest build() {
            return new DeleteResourceMemberRequest(this);
        }
    }
}

