/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class ListChangeRequestsRequest
extends Request {
    @Path
    @NameInMap(value="appName")
    @Validation(required=true)
    private String appName;
    @Query
    @NameInMap(value="appNameList")
    private List<String> appNameList;
    @Query
    @NameInMap(value="displayNameKeyword")
    private String displayNameKeyword;
    @Query
    @NameInMap(value="nextToken")
    private String nextToken;
    @Query
    @NameInMap(value="orderBy")
    private String orderBy;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="ownerIdList")
    private List<String> ownerIdList;
    @Query
    @NameInMap(value="page")
    private Integer page;
    @Query
    @NameInMap(value="pagination")
    private String pagination;
    @Query
    @NameInMap(value="perPage")
    private Integer perPage;
    @Query
    @NameInMap(value="sort")
    private String sort;
    @Query
    @NameInMap(value="stateList")
    private List<String> stateList;

    private ListChangeRequestsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.appNameList = builder.appNameList;
        this.displayNameKeyword = builder.displayNameKeyword;
        this.nextToken = builder.nextToken;
        this.orderBy = builder.orderBy;
        this.organizationId = builder.organizationId;
        this.ownerIdList = builder.ownerIdList;
        this.page = builder.page;
        this.pagination = builder.pagination;
        this.perPage = builder.perPage;
        this.sort = builder.sort;
        this.stateList = builder.stateList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListChangeRequestsRequest create() {
        return ListChangeRequestsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public List<String> getAppNameList() {
        return this.appNameList;
    }

    public String getDisplayNameKeyword() {
        return this.displayNameKeyword;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public List<String> getOwnerIdList() {
        return this.ownerIdList;
    }

    public Integer getPage() {
        return this.page;
    }

    public String getPagination() {
        return this.pagination;
    }

    public Integer getPerPage() {
        return this.perPage;
    }

    public String getSort() {
        return this.sort;
    }

    public List<String> getStateList() {
        return this.stateList;
    }

    public static final class Builder
    extends Request.Builder<ListChangeRequestsRequest, Builder> {
        private String appName;
        private List<String> appNameList;
        private String displayNameKeyword;
        private String nextToken;
        private String orderBy;
        private String organizationId;
        private List<String> ownerIdList;
        private Integer page;
        private String pagination;
        private Integer perPage;
        private String sort;
        private List<String> stateList;

        private Builder() {
        }

        private Builder(ListChangeRequestsRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.appNameList = request.appNameList;
            this.displayNameKeyword = request.displayNameKeyword;
            this.nextToken = request.nextToken;
            this.orderBy = request.orderBy;
            this.organizationId = request.organizationId;
            this.ownerIdList = request.ownerIdList;
            this.page = request.page;
            this.pagination = request.pagination;
            this.perPage = request.perPage;
            this.sort = request.sort;
            this.stateList = request.stateList;
        }

        public Builder appName(String appName) {
            this.putPathParameter("appName", appName);
            this.appName = appName;
            return this;
        }

        public Builder appNameList(List<String> appNameList) {
            String appNameListShrink = this.shrink(appNameList, "appNameList", "json");
            this.putQueryParameter("appNameList", appNameListShrink);
            this.appNameList = appNameList;
            return this;
        }

        public Builder displayNameKeyword(String displayNameKeyword) {
            this.putQueryParameter("displayNameKeyword", displayNameKeyword);
            this.displayNameKeyword = displayNameKeyword;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("nextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder orderBy(String orderBy) {
            this.putQueryParameter("orderBy", orderBy);
            this.orderBy = orderBy;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder ownerIdList(List<String> ownerIdList) {
            String ownerIdListShrink = this.shrink(ownerIdList, "ownerIdList", "json");
            this.putQueryParameter("ownerIdList", ownerIdListShrink);
            this.ownerIdList = ownerIdList;
            return this;
        }

        public Builder page(Integer page) {
            this.putQueryParameter("page", page);
            this.page = page;
            return this;
        }

        public Builder pagination(String pagination) {
            this.putQueryParameter("pagination", pagination);
            this.pagination = pagination;
            return this;
        }

        public Builder perPage(Integer perPage) {
            this.putQueryParameter("perPage", perPage);
            this.perPage = perPage;
            return this;
        }

        public Builder sort(String sort) {
            this.putQueryParameter("sort", sort);
            this.sort = sort;
            return this;
        }

        public Builder stateList(List<String> stateList) {
            String stateListShrink = this.shrink(stateList, "stateList", "json");
            this.putQueryParameter("stateList", stateListShrink);
            this.stateList = stateList;
            return this;
        }

        public ListChangeRequestsRequest build() {
            return new ListChangeRequestsRequest(this);
        }
    }
}

