/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListPipelineGroupsRequest
extends Request {
    @Path
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="maxResults")
    @Validation(maximum=50.0, minimum=1.0)
    private Long maxResults;
    @Query
    @NameInMap(value="nextToken")
    private String nextToken;

    private ListPipelineGroupsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.organizationId = builder.organizationId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListPipelineGroupsRequest create() {
        return ListPipelineGroupsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Long getMaxResults() {
        return this.maxResults;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public static final class Builder
    extends Request.Builder<ListPipelineGroupsRequest, Builder> {
        private String organizationId;
        private Long maxResults;
        private String nextToken;

        private Builder() {
        }

        private Builder(ListPipelineGroupsRequest request) {
            super((Request)request);
            this.organizationId = request.organizationId;
            this.maxResults = request.maxResults;
            this.nextToken = request.nextToken;
        }

        public Builder organizationId(String organizationId) {
            this.putPathParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder maxResults(Long maxResults) {
            this.putQueryParameter("maxResults", maxResults);
            this.maxResults = maxResults;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("nextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public ListPipelineGroupsRequest build() {
            return new ListPipelineGroupsRequest(this);
        }
    }
}

