/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListPipelineRunsRequest
extends Request {
    @Path
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Path
    @NameInMap(value="pipelineId")
    @Validation(required=true)
    private Long pipelineId;
    @Query
    @NameInMap(value="endTime")
    private Long endTime;
    @Query
    @NameInMap(value="maxResults")
    private Long maxResults;
    @Query
    @NameInMap(value="nextToken")
    private String nextToken;
    @Query
    @NameInMap(value="startTime")
    private Long startTime;
    @Query
    @NameInMap(value="status")
    private String status;
    @Query
    @NameInMap(value="triggerMode")
    private Integer triggerMode;

    private ListPipelineRunsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.organizationId = builder.organizationId;
        this.pipelineId = builder.pipelineId;
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.triggerMode = builder.triggerMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListPipelineRunsRequest create() {
        return ListPipelineRunsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Long getPipelineId() {
        return this.pipelineId;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Long getMaxResults() {
        return this.maxResults;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getTriggerMode() {
        return this.triggerMode;
    }

    public static final class Builder
    extends Request.Builder<ListPipelineRunsRequest, Builder> {
        private String organizationId;
        private Long pipelineId;
        private Long endTime;
        private Long maxResults;
        private String nextToken;
        private Long startTime;
        private String status;
        private Integer triggerMode;

        private Builder() {
        }

        private Builder(ListPipelineRunsRequest request) {
            super((Request)request);
            this.organizationId = request.organizationId;
            this.pipelineId = request.pipelineId;
            this.endTime = request.endTime;
            this.maxResults = request.maxResults;
            this.nextToken = request.nextToken;
            this.startTime = request.startTime;
            this.status = request.status;
            this.triggerMode = request.triggerMode;
        }

        public Builder organizationId(String organizationId) {
            this.putPathParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder pipelineId(Long pipelineId) {
            this.putPathParameter("pipelineId", pipelineId);
            this.pipelineId = pipelineId;
            return this;
        }

        public Builder endTime(Long endTime) {
            this.putQueryParameter("endTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder maxResults(Long maxResults) {
            this.putQueryParameter("maxResults", maxResults);
            this.maxResults = maxResults;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("nextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder startTime(Long startTime) {
            this.putQueryParameter("startTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public Builder status(String status) {
            this.putQueryParameter("status", status);
            this.status = status;
            return this;
        }

        public Builder triggerMode(Integer triggerMode) {
            this.putQueryParameter("triggerMode", triggerMode);
            this.triggerMode = triggerMode;
            return this;
        }

        public ListPipelineRunsRequest build() {
            return new ListPipelineRunsRequest(this);
        }
    }
}

