/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListRepositoriesRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Query
    @NameInMap(value="archived")
    private Boolean archived;
    @Query
    @NameInMap(value="minAccessLevel")
    private Integer minAccessLevel;
    @Query
    @NameInMap(value="orderBy")
    private String orderBy;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="page")
    private Long page;
    @Query
    @NameInMap(value="perPage")
    private Long perPage;
    @Query
    @NameInMap(value="search")
    private String search;
    @Query
    @NameInMap(value="sort")
    private String sort;

    private ListRepositoriesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.archived = builder.archived;
        this.minAccessLevel = builder.minAccessLevel;
        this.orderBy = builder.orderBy;
        this.organizationId = builder.organizationId;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.search = builder.search;
        this.sort = builder.sort;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListRepositoriesRequest create() {
        return ListRepositoriesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Boolean getArchived() {
        return this.archived;
    }

    public Integer getMinAccessLevel() {
        return this.minAccessLevel;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Long getPage() {
        return this.page;
    }

    public Long getPerPage() {
        return this.perPage;
    }

    public String getSearch() {
        return this.search;
    }

    public String getSort() {
        return this.sort;
    }

    public static final class Builder
    extends Request.Builder<ListRepositoriesRequest, Builder> {
        private String accessToken;
        private Boolean archived;
        private Integer minAccessLevel;
        private String orderBy;
        private String organizationId;
        private Long page;
        private Long perPage;
        private String search;
        private String sort;

        private Builder() {
        }

        private Builder(ListRepositoriesRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.archived = request.archived;
            this.minAccessLevel = request.minAccessLevel;
            this.orderBy = request.orderBy;
            this.organizationId = request.organizationId;
            this.page = request.page;
            this.perPage = request.perPage;
            this.search = request.search;
            this.sort = request.sort;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder archived(Boolean archived) {
            this.putQueryParameter("archived", archived);
            this.archived = archived;
            return this;
        }

        public Builder minAccessLevel(Integer minAccessLevel) {
            this.putQueryParameter("minAccessLevel", minAccessLevel);
            this.minAccessLevel = minAccessLevel;
            return this;
        }

        public Builder orderBy(String orderBy) {
            this.putQueryParameter("orderBy", orderBy);
            this.orderBy = orderBy;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder page(Long page) {
            this.putQueryParameter("page", page);
            this.page = page;
            return this;
        }

        public Builder perPage(Long perPage) {
            this.putQueryParameter("perPage", perPage);
            this.perPage = perPage;
            return this;
        }

        public Builder search(String search) {
            this.putQueryParameter("search", search);
            this.search = search;
            return this;
        }

        public Builder sort(String sort) {
            this.putQueryParameter("sort", sort);
            this.sort = sort;
            return this;
        }

        public ListRepositoriesRequest build() {
            return new ListRepositoriesRequest(this);
        }
    }
}

