/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListRepositoryTagsRequest
extends Request {
    @Path
    @NameInMap(value="repositoryId")
    @Validation(required=true)
    private Long repositoryId;
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;
    @Query
    @NameInMap(value="page")
    private Long page;
    @Query
    @NameInMap(value="pageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="search")
    private String search;
    @Query
    @NameInMap(value="sort")
    private String sort;

    private ListRepositoryTagsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.repositoryId = builder.repositoryId;
        this.accessToken = builder.accessToken;
        this.organizationId = builder.organizationId;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.search = builder.search;
        this.sort = builder.sort;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListRepositoryTagsRequest create() {
        return ListRepositoryTagsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getRepositoryId() {
        return this.repositoryId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Long getPage() {
        return this.page;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getSearch() {
        return this.search;
    }

    public String getSort() {
        return this.sort;
    }

    public static final class Builder
    extends Request.Builder<ListRepositoryTagsRequest, Builder> {
        private Long repositoryId;
        private String accessToken;
        private String organizationId;
        private Long page;
        private Long pageSize;
        private String search;
        private String sort;

        private Builder() {
        }

        private Builder(ListRepositoryTagsRequest request) {
            super((Request)request);
            this.repositoryId = request.repositoryId;
            this.accessToken = request.accessToken;
            this.organizationId = request.organizationId;
            this.page = request.page;
            this.pageSize = request.pageSize;
            this.search = request.search;
            this.sort = request.sort;
        }

        public Builder repositoryId(Long repositoryId) {
            this.putPathParameter("repositoryId", repositoryId);
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public Builder page(Long page) {
            this.putQueryParameter("page", page);
            this.page = page;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("pageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder search(String search) {
            this.putQueryParameter("search", search);
            this.search = search;
            return this;
        }

        public Builder sort(String sort) {
            this.putQueryParameter("sort", sort);
            this.sort = sort;
            return this;
        }

        public ListRepositoryTagsRequest build() {
            return new ListRepositoryTagsRequest(this);
        }
    }
}

