/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateAppMemberRequest
extends Request {
    @Path
    @NameInMap(value="appName")
    private String appName;
    @Body
    @NameInMap(value="player")
    private Player player;
    @Body
    @NameInMap(value="roleNames")
    private List<String> roleNames;
    @Query
    @NameInMap(value="organizationId")
    private String organizationId;

    private UpdateAppMemberRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appName = builder.appName;
        this.player = builder.player;
        this.roleNames = builder.roleNames;
        this.organizationId = builder.organizationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateAppMemberRequest create() {
        return UpdateAppMemberRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public Player getPlayer() {
        return this.player;
    }

    public List<String> getRoleNames() {
        return this.roleNames;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class Player
    extends TeaModel {
        @NameInMap(value="id")
        private String id;
        @NameInMap(value="type")
        private String type;

        private Player(Builder builder) {
            this.id = builder.id;
            this.type = builder.type;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Player create() {
            return Player.builder().build();
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public static final class Builder {
            private String id;
            private String type;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Player build() {
                return new Player(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateAppMemberRequest, Builder> {
        private String appName;
        private Player player;
        private List<String> roleNames;
        private String organizationId;

        private Builder() {
        }

        private Builder(UpdateAppMemberRequest request) {
            super((Request)request);
            this.appName = request.appName;
            this.player = request.player;
            this.roleNames = request.roleNames;
            this.organizationId = request.organizationId;
        }

        public Builder appName(String appName) {
            this.putPathParameter("appName", appName);
            this.appName = appName;
            return this;
        }

        public Builder player(Player player) {
            this.putBodyParameter("player", (Object)player);
            this.player = player;
            return this;
        }

        public Builder roleNames(List<String> roleNames) {
            this.putBodyParameter("roleNames", roleNames);
            this.roleNames = roleNames;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public UpdateAppMemberRequest build() {
            return new UpdateAppMemberRequest(this);
        }
    }
}

