/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.devops20210625.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateGroupRequest
extends Request {
    @Query
    @NameInMap(value="accessToken")
    private String accessToken;
    @Body
    @NameInMap(value="avatarUrl")
    private String avatarUrl;
    @Body
    @NameInMap(value="description")
    private String description;
    @Body
    @NameInMap(value="name")
    @Validation(required=true)
    private String name;
    @Body
    @NameInMap(value="path")
    @Validation(required=true)
    private String path;
    @Body
    @NameInMap(value="pathWithNamespace")
    @Validation(required=true)
    private String pathWithNamespace;
    @Body
    @NameInMap(value="visibilityLevel")
    private Integer visibilityLevel;
    @Query
    @NameInMap(value="organizationId")
    @Validation(required=true)
    private String organizationId;

    private UpdateGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessToken = builder.accessToken;
        this.avatarUrl = builder.avatarUrl;
        this.description = builder.description;
        this.name = builder.name;
        this.path = builder.path;
        this.pathWithNamespace = builder.pathWithNamespace;
        this.visibilityLevel = builder.visibilityLevel;
        this.organizationId = builder.organizationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateGroupRequest create() {
        return UpdateGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getPathWithNamespace() {
        return this.pathWithNamespace;
    }

    public Integer getVisibilityLevel() {
        return this.visibilityLevel;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public static final class Builder
    extends Request.Builder<UpdateGroupRequest, Builder> {
        private String accessToken;
        private String avatarUrl;
        private String description;
        private String name;
        private String path;
        private String pathWithNamespace;
        private Integer visibilityLevel;
        private String organizationId;

        private Builder() {
        }

        private Builder(UpdateGroupRequest request) {
            super((Request)request);
            this.accessToken = request.accessToken;
            this.avatarUrl = request.avatarUrl;
            this.description = request.description;
            this.name = request.name;
            this.path = request.path;
            this.pathWithNamespace = request.pathWithNamespace;
            this.visibilityLevel = request.visibilityLevel;
            this.organizationId = request.organizationId;
        }

        public Builder accessToken(String accessToken) {
            this.putQueryParameter("accessToken", accessToken);
            this.accessToken = accessToken;
            return this;
        }

        public Builder avatarUrl(String avatarUrl) {
            this.putBodyParameter("avatarUrl", avatarUrl);
            this.avatarUrl = avatarUrl;
            return this;
        }

        public Builder description(String description) {
            this.putBodyParameter("description", description);
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.putBodyParameter("name", name);
            this.name = name;
            return this;
        }

        public Builder path(String path) {
            this.putBodyParameter("path", path);
            this.path = path;
            return this;
        }

        public Builder pathWithNamespace(String pathWithNamespace) {
            this.putBodyParameter("pathWithNamespace", pathWithNamespace);
            this.pathWithNamespace = pathWithNamespace;
            return this;
        }

        public Builder visibilityLevel(Integer visibilityLevel) {
            this.putBodyParameter("visibilityLevel", visibilityLevel);
            this.visibilityLevel = visibilityLevel;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.putQueryParameter("organizationId", organizationId);
            this.organizationId = organizationId;
            return this;
        }

        public UpdateGroupRequest build() {
            return new UpdateGroupRequest(this);
        }
    }
}

