/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.aliyuncs.cdn.transform.v20141111;

import java.util.ArrayList;
import java.util.List;

import com.aliyuncs.cdn.model.v20141111.DescribeDomainWafDataResponse;
import com.aliyuncs.cdn.model.v20141111.DescribeDomainWafDataResponse.WafDatas;
import com.aliyuncs.transform.UnmarshallerContext;


public class DescribeDomainWafDataResponseUnmarshaller {

	public static DescribeDomainWafDataResponse unmarshall(DescribeDomainWafDataResponse describeDomainWafDataResponse, UnmarshallerContext context) {
		
		describeDomainWafDataResponse.setRequestId(context.stringValue("DescribeDomainWafDataResponse.RequestId"));
		describeDomainWafDataResponse.setDomainName(context.stringValue("DescribeDomainWafDataResponse.DomainName"));
		describeDomainWafDataResponse.setDataInterval(context.stringValue("DescribeDomainWafDataResponse.DataInterval"));
		describeDomainWafDataResponse.setStartTime(context.stringValue("DescribeDomainWafDataResponse.StartTime"));
		describeDomainWafDataResponse.setEndTime(context.stringValue("DescribeDomainWafDataResponse.EndTime"));

		List<WafDatas> wafDataList = new ArrayList<WafDatas>();
		for (int i = 0; i < context.lengthValue("DescribeDomainWafDataResponse.WafDataList.Length"); i++) {
			WafDatas wafDatas = new WafDatas();
			wafDatas.setTimeStamp(context.stringValue("DescribeDomainWafDataResponse.WafDataList["+ i +"].TimeStamp"));

			List<String> value = new ArrayList<String>();
			for (int j = 0; j < context.lengthValue("DescribeDomainWafDataResponse.WafDataList["+ i +"].Value.Length"); j++) {
				value.add(context.stringValue("DescribeDomainWafDataResponse.WafDataList["+ i +"].Value["+ j +"]"));
			}
			wafDatas.setValue(value);

			wafDataList.add(wafDatas);
		}
		describeDomainWafDataResponse.setWafDataList(wafDataList);
	 
	 	return describeDomainWafDataResponse;
	}
}