/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.cdn.model.v20180510;

import com.aliyuncs.RpcAcsRequest;

/**
 * @author auto create
 * @version 
 */
public class BatchDeleteCdnDomainConfigRequest extends RpcAcsRequest<BatchDeleteCdnDomainConfigResponse> {
	
	public BatchDeleteCdnDomainConfigRequest() {
		super("Cdn", "2018-05-10", "BatchDeleteCdnDomainConfig");
	}

	private String functionNames;

	private String securityToken;

	private String domainNames;

	private String ownerAccount;

	private Long ownerId;

	public String getFunctionNames() {
		return this.functionNames;
	}

	public void setFunctionNames(String functionNames) {
		this.functionNames = functionNames;
		if(functionNames != null){
			putQueryParameter("FunctionNames", functionNames);
		}
	}

	public String getSecurityToken() {
		return this.securityToken;
	}

	public void setSecurityToken(String securityToken) {
		this.securityToken = securityToken;
		if(securityToken != null){
			putQueryParameter("SecurityToken", securityToken);
		}
	}

	public String getDomainNames() {
		return this.domainNames;
	}

	public void setDomainNames(String domainNames) {
		this.domainNames = domainNames;
		if(domainNames != null){
			putQueryParameter("DomainNames", domainNames);
		}
	}

	public String getOwnerAccount() {
		return this.ownerAccount;
	}

	public void setOwnerAccount(String ownerAccount) {
		this.ownerAccount = ownerAccount;
		if(ownerAccount != null){
			putQueryParameter("OwnerAccount", ownerAccount);
		}
	}

	public Long getOwnerId() {
		return this.ownerId;
	}

	public void setOwnerId(Long ownerId) {
		this.ownerId = ownerId;
		if(ownerId != null){
			putQueryParameter("OwnerId", ownerId.toString());
		}
	}

	@Override
	public Class<BatchDeleteCdnDomainConfigResponse> getResponseClass() {
		return BatchDeleteCdnDomainConfigResponse.class;
	}

}
