/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.io.IOException;
import org.apache.calcite.avatica.AvaticaSeverity;
import org.apache.calcite.avatica.NoSuchConnectionException;
import org.apache.calcite.avatica.remote.AvaticaRuntimeException;
import org.apache.calcite.avatica.remote.Handler;
import org.apache.calcite.avatica.remote.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHandler<T>
implements Handler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHandler.class);
    private static final String NULL_EXCEPTION_MESSAGE = "(null exception message)";
    protected final Service service;
    private Service.RpcMetadataResponse metadata = null;

    public AbstractHandler(Service service) {
        this.service = service;
    }

    abstract Service.Request decode(T var1) throws IOException;

    abstract T encode(Service.Response var1) throws IOException;

    Service.ErrorResponse unwrapException(Exception e) {
        int errorCode = -1;
        String sqlState = "00000";
        AvaticaSeverity severity = AvaticaSeverity.UNKNOWN;
        String errorMsg = null;
        if (e instanceof AvaticaRuntimeException) {
            AvaticaRuntimeException rte = (AvaticaRuntimeException)e;
            errorCode = rte.getErrorCode();
            sqlState = rte.getSqlState();
            severity = rte.getSeverity();
            errorMsg = rte.getErrorMessage();
        } else if (e instanceof NoSuchConnectionException) {
            errorCode = 1;
            severity = AvaticaSeverity.ERROR;
            errorMsg = e.getMessage();
        } else {
            errorMsg = this.getCausalChain(e);
        }
        return new Service.ErrorResponse(e, errorMsg, errorCode, sqlState, severity, this.metadata);
    }

    @Override
    public Handler.HandlerResponse<T> apply(T serializedRequest) {
        try {
            Service.Request request = this.decode(serializedRequest);
            Service.Response response = request.accept(this.service);
            return new Handler.HandlerResponse<T>(this.encode(response), 200);
        }
        catch (Exception e) {
            return this.convertToErrorResponse(e);
        }
    }

    public Handler.HandlerResponse<T> convertToErrorResponse(Exception e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("found exception", e);
        }
        return this.createErrorResponse(e, 500);
    }

    public Handler.HandlerResponse<T> unauthenticatedErrorResponse(Exception e) {
        return this.createErrorResponse(e, 401);
    }

    public Handler.HandlerResponse<T> unauthorizedErrorResponse(Exception e) {
        return this.createErrorResponse(e, 403);
    }

    private Handler.HandlerResponse<T> createErrorResponse(Exception e, int statusCode) {
        Service.ErrorResponse errorResp = this.unwrapException(e);
        try {
            return new Handler.HandlerResponse<T>(this.encode(errorResp), statusCode);
        }
        catch (IOException e1) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private String getCausalChain(Exception e) {
        StringBuilder sb = new StringBuilder(16);
        for (Throwable curr = e; null != curr; curr = curr.getCause()) {
            if (sb.length() > 0) {
                sb.append(" -> ");
            }
            String message = curr.getMessage();
            sb.append(curr.getClass().getSimpleName()).append(": ");
            sb.append(null == message ? NULL_EXCEPTION_MESSAGE : message);
        }
        if (sb.length() == 0) {
            return "Unknown error message";
        }
        return sb.toString();
    }

    @Override
    public void setRpcMetadata(Service.RpcMetadataResponse metadata) {
        this.metadata = metadata;
    }
}

