/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.hbase.client.ClientUtil;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.LayeredHTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableBuilderBase;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class HotHTable
extends LayeredHTable {
    protected long hotTtl = -1L;

    @InterfaceAudience.Private
    protected HotHTable(ClusterConnection connection, TableBuilderBase builder, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, ExecutorService pool, long hotTtl) {
        super(connection, builder, rpcCallerFactory, rpcControllerFactory, pool);
        this.hotTtl = hotTtl;
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        Scan hotScan = ClientUtil.removeColdDataFromScan(scan, this.hotTtl);
        return this.getRawScanner(hotScan);
    }

    @Override
    protected Result get(Get get, boolean checkExistenceOnly) throws IOException {
        Get hotGet = ClientUtil.removeColdDataFromGet(get, this.hotTtl);
        return this.rawGet(hotGet, checkExistenceOnly);
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        if (gets.size() == 1) {
            return new Result[]{this.get(gets.get(0))};
        }
        List<Get> hotGets = ClientUtil.removeColdDataFromGets(gets, this.hotTtl);
        return this.rawGet(hotGets);
    }
}

